/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.argument.type;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import me.hsgamer.bettergui.argument.type.SingleArgumentProcessor;
import me.hsgamer.bettergui.builder.ArgumentProcessorBuilder;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlayerArgumentProcessor
extends SingleArgumentProcessor<OfflinePlayer> {
    private final boolean onlineOnly;

    public PlayerArgumentProcessor(ArgumentProcessorBuilder.Input input) {
        super(input);
        this.onlineOnly = Optional.ofNullable(MapUtils.getIfFound(this.options, "online-only", "online")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    protected Optional<OfflinePlayer> getObject(String name) {
        if (this.onlineOnly) {
            return Optional.ofNullable(Bukkit.getPlayer((String)name));
        }
        return Optional.ofNullable(Bukkit.getOfflinePlayer((String)name));
    }

    @Override
    protected Stream<OfflinePlayer> getObjectStream() {
        if (this.onlineOnly) {
            return Arrays.stream(Bukkit.getOnlinePlayers().toArray(new OfflinePlayer[0]));
        }
        return Arrays.stream(Bukkit.getOfflinePlayers());
    }

    @Override
    protected String getArgumentValue(OfflinePlayer object) {
        return Optional.ofNullable(object.getName()).orElse("");
    }

    @Override
    protected String getValue(String query, UUID uuid, OfflinePlayer object) {
        return StringReplacerApplier.replace(StringReplacerApplier.normalizeQuery(query), object.getUniqueId(), this);
    }
}

