/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.argument.type;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.bettergui.argument.type.SingleArgumentProcessor;
import me.hsgamer.bettergui.builder.ArgumentProcessorBuilder;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.common.Validate;

public class NumberArgumentProcessor
extends SingleArgumentProcessor<Long> {
    private final List<Long> suggestions;

    public NumberArgumentProcessor(ArgumentProcessorBuilder.Input input) {
        super(input);
        this.suggestions = Optional.ofNullable(MapUtils.getIfFound(this.options, "suggestion", "suggest")).map(CollectionUtils::createStringListFromObject).orElseGet(() -> Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9")).stream().flatMap(s -> Validate.getNumber(s).map(Stream::of).orElseGet(Stream::empty)).map(Number::longValue).collect(Collectors.toList());
    }

    @Override
    protected Optional<Long> getObject(String name) {
        try {
            return Optional.of(Long.parseLong(name));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    protected Stream<Long> getObjectStream() {
        return this.suggestions.stream();
    }

    @Override
    protected String getArgumentValue(Long object) {
        return Long.toString(object);
    }

    @Override
    protected String getValue(String query, UUID uuid, Long object) {
        return "";
    }
}

