/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.argument;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.bettergui.api.argument.ArgumentProcessor;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.builder.ArgumentProcessorBuilder;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;
import me.hsgamer.bettergui.lib.core.common.Pair;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;

public class ArgumentHandler
implements ArgumentProcessor {
    private final Menu menu;
    private final Map<String, ArgumentProcessor> processorMap = new LinkedHashMap<String, ArgumentProcessor>();

    public ArgumentHandler(Menu menu, Map<String, Object> section) {
        this.menu = menu;
        CaseInsensitiveStringMap<Object> keys = new CaseInsensitiveStringMap<Object>(section);
        keys.forEach((key, value) -> {
            if (value instanceof Map) {
                Map map = (Map)value;
                ArgumentProcessorBuilder.INSTANCE.build(new ArgumentProcessorBuilder.Input(menu, (String)key, map)).ifPresent(processor -> this.processorMap.put((String)key, (ArgumentProcessor)processor));
            }
        });
        menu.getVariableManager().register("arg_", StringReplacer.of(this::getValue));
    }

    @Override
    public Optional<String[]> process(UUID uuid, String[] args) {
        for (ArgumentProcessor processor : this.processorMap.values()) {
            Optional<String[]> optional = processor.process(uuid, args);
            if (optional.isPresent()) {
                args = optional.get();
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(args);
    }

    @Override
    public String getValue(String query, UUID uuid) {
        for (Map.Entry<String, ArgumentProcessor> entry : this.processorMap.entrySet()) {
            String key = entry.getKey();
            if (!query.toLowerCase(Locale.ROOT).startsWith(key.toLowerCase(Locale.ROOT))) continue;
            String subQuery = query.substring(key.length());
            if (subQuery.startsWith("_")) {
                subQuery = subQuery.substring(1);
            }
            return entry.getValue().getValue(subQuery, uuid);
        }
        return "";
    }

    @Override
    public Pair<Optional<List<String>>, String[]> tabComplete(UUID uuid, String[] args) {
        for (ArgumentProcessor processor : this.processorMap.values()) {
            Pair<Optional<List<String>>, String[]> pair = processor.tabComplete(uuid, args);
            Optional<List<String>> optional = pair.getKey();
            if (optional.isPresent()) {
                return pair;
            }
            args = pair.getValue();
        }
        return Pair.of(Optional.empty(), args);
    }

    public List<String> handleTabComplete(UUID uuid, String[] args) {
        return this.tabComplete(uuid, args).getKey().orElse(Collections.emptyList());
    }

    @Override
    public Menu getMenu() {
        return this.menu;
    }
}

