/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.api.requirement;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.hsgamer.bettergui.api.process.ProcessApplier;
import me.hsgamer.bettergui.api.requirement.BaseRequirement;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.RequirementBuilder;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;

public abstract class TakableRequirement<V>
extends BaseRequirement<V> {
    private boolean take;

    protected TakableRequirement(RequirementBuilder.Input input) {
        super(input);
    }

    @Override
    protected Object handleValue(Object inputValue) {
        if (inputValue instanceof Map) {
            CaseInsensitiveStringMap keys = new CaseInsensitiveStringMap((Map)inputValue);
            this.take = Optional.ofNullable(keys.get("take")).map(String::valueOf).map(Boolean::parseBoolean).orElse(this.getDefaultTake());
            return super.handleValue(Optional.ofNullable(keys.get("value")).orElse(this.getDefaultValue()));
        }
        this.take = this.getDefaultTake();
        return super.handleValue(inputValue);
    }

    protected abstract boolean getDefaultTake();

    protected abstract Object getDefaultValue();

    public Requirement.Result successConditional(ProcessApplier applier) {
        return new Requirement.Result(true, (uuid, process) -> {
            if (this.take) {
                applier.accept(uuid, process);
            } else {
                process.next();
            }
        });
    }

    public Requirement.Result successConditional(Consumer<UUID> applier) {
        return this.successConditional((uuid, process) -> {
            applier.accept((UUID)uuid);
            process.next();
        });
    }
}

