/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.hsgamer.bettergui.Permissions;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.builder.ActionBuilder;
import me.hsgamer.bettergui.builder.ButtonBuilder;
import me.hsgamer.bettergui.builder.ItemModifierBuilder;
import me.hsgamer.bettergui.builder.MenuBuilder;
import me.hsgamer.bettergui.builder.RequirementBuilder;
import me.hsgamer.bettergui.command.GetAddonsCommand;
import me.hsgamer.bettergui.command.GetTemplateButtonsCommand;
import me.hsgamer.bettergui.command.GetVariablesCommand;
import me.hsgamer.bettergui.command.MainCommand;
import me.hsgamer.bettergui.command.OpenCommand;
import me.hsgamer.bettergui.command.ReloadCommand;
import me.hsgamer.bettergui.config.MainConfig;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.config.TemplateConfig;
import me.hsgamer.bettergui.downloader.AddonDownloader;
import me.hsgamer.bettergui.lib.bstats.bukkit.Metrics;
import me.hsgamer.bettergui.lib.bstats.charts.AdvancedPie;
import me.hsgamer.bettergui.lib.bstats.charts.DrilldownPie;
import me.hsgamer.bettergui.lib.core.bukkit.config.BukkitConfig;
import me.hsgamer.bettergui.lib.core.bukkit.gui.BukkitGUIListener;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.core.bukkit.variable.BukkitVariableBundle;
import me.hsgamer.bettergui.lib.core.checker.spigotmc.SpigotVersionChecker;
import me.hsgamer.bettergui.lib.core.common.CachedValue;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.config.proxy.ConfigGenerator;
import me.hsgamer.bettergui.lib.core.variable.CommonVariableBundle;
import me.hsgamer.bettergui.lib.core.variable.VariableBundle;
import me.hsgamer.bettergui.lib.minelib.plugin.base.BasePlugin;
import me.hsgamer.bettergui.lib.minelib.plugin.command.CommandComponent;
import me.hsgamer.bettergui.lib.minelib.plugin.postenable.PostEnable;
import me.hsgamer.bettergui.lib.minelib.plugin.postenable.PostEnableComponent;
import me.hsgamer.bettergui.manager.AddonManager;
import me.hsgamer.bettergui.manager.MenuCommandManager;
import me.hsgamer.bettergui.manager.MenuManager;
import me.hsgamer.bettergui.papi.ExtraPlaceholderExpansion;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BetterGUI
extends BasePlugin
implements PostEnable {
    private static final CachedValue<BetterGUI> INSTANCE_CACHE = CachedValue.of(() -> (BetterGUI)JavaPlugin.getPlugin(BetterGUI.class));

    public static BetterGUI getInstance() {
        return INSTANCE_CACHE.get();
    }

    @Override
    protected List<Object> getComponents() {
        VariableBundle variableBundle = new VariableBundle();
        CommonVariableBundle.registerVariables(variableBundle);
        BukkitVariableBundle.registerVariables(variableBundle);
        variableBundle.register("menu_", StringReplacer.of((original, uuid) -> {
            String[] split = original.split("_", 2);
            String menuName = split[0].trim();
            String variable = split.length > 1 ? split[1].trim() : "";
            Menu menu = this.get(MenuManager.class).getMenu(menuName);
            if (menu == null) {
                return null;
            }
            return menu.getVariableManager().setVariables(StringReplacerApplier.normalizeQuery(variable), (UUID)uuid);
        }));
        ArrayList<Object> components = new ArrayList<Object>(Arrays.asList(variableBundle, new PostEnableComponent(this), new Permissions(this), new CommandComponent((BasePlugin)this, new Command[]{new OpenCommand(this), new MainCommand(this), new GetAddonsCommand(this), new ReloadCommand(this), new GetVariablesCommand(this), new GetTemplateButtonsCommand(this)}), ConfigGenerator.newInstance(MainConfig.class, new BukkitConfig((Plugin)this, "config.yml")), ConfigGenerator.newInstance(MessageConfig.class, new BukkitConfig((Plugin)this, "messages.yml")), new TemplateConfig(this), new AddonManager(this), new MenuManager(this), new MenuCommandManager(this), new AddonDownloader(this)));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            components.add(new ExtraPlaceholderExpansion(this));
        }
        return components;
    }

    @Override
    public void load() {
        MessageUtils.setPrefix(() -> this.get(MessageConfig.class).getPrefix());
    }

    @Override
    public void enable() {
        BukkitGUIListener.init((Plugin)this);
    }

    @Override
    public void postEnable() {
        this.get(AddonManager.class).call(me.hsgamer.bettergui.api.addon.PostEnable.class, me.hsgamer.bettergui.api.addon.PostEnable::onPostEnable);
        Metrics metrics = new Metrics((Plugin)this, 6609);
        metrics.addCustomChart(new DrilldownPie("addon", () -> {
            HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
            Map<String, Integer> addons = this.get(AddonManager.class).getExpansionCount();
            map.put(String.valueOf(addons.size()), addons);
            return map;
        }));
        metrics.addCustomChart(new AdvancedPie("addon_count", this.get(AddonManager.class)::getExpansionCount));
        if (this.getDescription().getVersion().contains("SNAPSHOT")) {
            this.getLogger().warning("You are using the development version");
            this.getLogger().warning("This is not ready for production");
            this.getLogger().warning("Use in your own risk");
        } else {
            new SpigotVersionChecker(75620).getVersion().thenAccept(output -> {
                if (output.startsWith("Error when getting version:")) {
                    this.getLogger().warning((String)output);
                } else if (this.getDescription().getVersion().equalsIgnoreCase((String)output)) {
                    this.getLogger().info("You are using the latest version");
                } else {
                    this.getLogger().warning("There is an available update");
                    this.getLogger().warning("New Version: " + output);
                }
            });
        }
    }

    @Override
    public void disable() {
        ActionBuilder.INSTANCE.clear();
        ButtonBuilder.INSTANCE.clear();
        ItemModifierBuilder.INSTANCE.clear();
        MenuBuilder.INSTANCE.clear();
        RequirementBuilder.INSTANCE.clear();
        this.get(VariableBundle.class).unregisterAll();
        INSTANCE_CACHE.clearCache();
    }
}

