/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener.loadable.explosion.vanilla.unhandled;

import io.github.guillex7.explodeany.compat.common.data.ExplodingVanillaEntity;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.LoadableConfigurationSection;
import io.github.guillex7.explodeany.configuration.loadable.vanilla.CustomVanillaEntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.explosion.ExplosionManager;
import io.github.guillex7.explodeany.listener.loadable.explosion.vanilla.BaseUnhandledVanillaExplosionListener;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public class UnhandledUnknownVanillaExplosionListener
extends BaseUnhandledVanillaExplosionListener {
    @Override
    public String getName() {
        return "Custom entities explosions";
    }

    @Override
    public boolean isAnnounceable() {
        return false;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.NORMAL)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.isEventHandled(event)) {
            return;
        }
        EntityType entityType = event.getEntityType();
        String entityTypeName = entityType.toString();
        Map<Material, EntityMaterialConfiguration> materialConfigurations = this.configuration.getEntityMaterialConfigurations().get(entityTypeName);
        EntityConfiguration entityConfiguration = this.configuration.getEntityConfigurations().get(entityTypeName);
        if (materialConfigurations == null || entityConfiguration == null) {
            return;
        }
        double explosionRadius = entityConfiguration.getExplosionRadius();
        if (explosionRadius == 0.0) {
            return;
        }
        if (ExplosionManager.getInstance().manageExplosion(materialConfigurations, entityConfiguration, event.getLocation(), explosionRadius)) {
            event.setCancelled(true);
        } else {
            ExplosionManager.getInstance().removeHandledBlocksFromList(materialConfigurations, event.blockList());
        }
    }

    @Override
    public void unload() {
        EntityExplodeEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    protected LoadableConfigurationSection<?> getConfiguration() {
        return ConfigurationManager.getInstance().getRegisteredLoadableConfigurationSection(CustomVanillaEntityConfiguration.getConfigurationId());
    }

    @Override
    protected boolean isEventHandled(EntityExplodeEvent event) {
        return super.isEventHandled(event) && !ExplodingVanillaEntity.isEntityNameValid(event.getEntityType().toString());
    }
}

