/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;

public class SoundConfiguration {
    public static final String ROOT_PATH = "Sound";
    private static final String NAME_PATH = "Name";
    private static final String VOLUME_PATH = "Volume";
    private static final String PITCH_PATH = "Pitch";
    private Sound sound;
    private double volume;
    private double pitch;

    private SoundConfiguration(Sound sound, double volume, double pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static SoundConfiguration of(Sound sound, double volume, double pitch) {
        return new SoundConfiguration(sound, volume, pitch);
    }

    public static SoundConfiguration byDefault() {
        return SoundConfiguration.of(null, 1.0, 1.0);
    }

    public static SoundConfiguration fromConfigurationSection(ConfigurationSection section) {
        Sound sound;
        SoundConfiguration defaults = SoundConfiguration.byDefault();
        try {
            sound = Sound.valueOf((String)section.getString(NAME_PATH, "").toUpperCase());
        }
        catch (Exception e) {
            sound = null;
        }
        return SoundConfiguration.of(sound, MathUtils.ensureMin(section.getDouble(VOLUME_PATH, defaults.getVolume()), 0.0), MathUtils.ensureRange(section.getDouble(PITCH_PATH, defaults.getPitch()), 2.0, 0.5));
    }

    public void playAt(Location location) {
        location.getWorld().playSound(location, this.sound, (float)this.volume, (float)this.pitch);
    }

    public boolean isValid() {
        return this.sound != null;
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sound == null ? 0 : this.sound.hashCode());
        long temp = Double.doubleToLongBits(this.volume);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.pitch);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoundConfiguration other = (SoundConfiguration)obj;
        if (this.sound != other.sound) {
            return false;
        }
        if (Double.doubleToLongBits(this.volume) != Double.doubleToLongBits(other.volume)) {
            return false;
        }
        return Double.doubleToLongBits(this.pitch) == Double.doubleToLongBits(other.pitch);
    }

    public String toString() {
        return this.isValid() ? String.format("Sound name: %s\nVolume: %.2f\nPitch: %.2f", this.getSound().name(), this.getVolume(), this.getPitch()) : "(None)";
    }
}

