/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.compat.common.api.IParticle;
import io.github.guillex7.explodeany.compat.common.data.ParticleData;
import io.github.guillex7.explodeany.compat.manager.CompatibilityManager;
import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class ParticleConfiguration {
    public static final String ROOT_PATH = "Particles";
    private static final String NAME_PATH = "Name";
    private static final String DELTA_X_PATH = "DeltaX";
    private static final String DELTA_Y_PATH = "DeltaY";
    private static final String DELTA_Z_PATH = "DeltaZ";
    private static final String AMOUNT_PATH = "Amount";
    private static final String SPEED_PATH = "Speed";
    private static final String FORCE_PATH = "Force";
    private static final String RED_PATH = "Red";
    private static final String BLUE_PATH = "Blue";
    private static final String GREEN_PATH = "Green";
    private static final String SIZE_PATH = "Size";
    private static final String MATERIAL_PATH = "Material";
    private IParticle particle;
    private double deltaX;
    private double deltaY;
    private double deltaZ;
    private int amount;
    private double speed;
    private boolean force;

    public ParticleConfiguration(IParticle particle, double deltaX, double deltaY, double deltaZ, int amount, double speed, boolean force) {
        this.particle = particle;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.deltaZ = deltaZ;
        this.amount = amount;
        this.speed = speed;
        this.force = force;
    }

    public static ParticleConfiguration of(IParticle particle, double deltaX, double deltaY, double deltaZ, int amount, double speed, boolean force) {
        return new ParticleConfiguration(particle, deltaX, deltaY, deltaZ, amount, speed, force);
    }

    public static ParticleConfiguration byDefault() {
        return new ParticleConfiguration(null, 1.0, 1.0, 1.0, 1000, 1.0, false);
    }

    public static ParticleConfiguration fromConfigurationSection(ConfigurationSection section) {
        Material material;
        ParticleConfiguration defaults = ParticleConfiguration.byDefault();
        String name = section.getString(NAME_PATH, "").toUpperCase();
        int red = MathUtils.ensureRange(section.getInt(RED_PATH, 0), 255, 0);
        int green = MathUtils.ensureRange(section.getInt(GREEN_PATH, 0), 255, 0);
        int blue = MathUtils.ensureRange(section.getInt(BLUE_PATH, 0), 255, 0);
        double size = MathUtils.ensureMin(section.getDouble(SIZE_PATH, 1.0), 0.0);
        try {
            material = Material.valueOf((String)section.getString(MATERIAL_PATH, "").toUpperCase());
        }
        catch (Exception e) {
            material = null;
        }
        IParticle particle = CompatibilityManager.getInstance().getApi().getParticleUtils().createParticle(new ParticleData(name, red, green, blue, size, material));
        return ParticleConfiguration.of(particle, section.getDouble(DELTA_X_PATH, defaults.getDeltaX()), section.getDouble(DELTA_Y_PATH, defaults.getDeltaY()), section.getDouble(DELTA_Z_PATH, defaults.getDeltaZ()), MathUtils.ensureMin(section.getInt(AMOUNT_PATH, defaults.getAmount()), 0), MathUtils.ensureMin(section.getDouble(SPEED_PATH, defaults.getSpeed()), 0.0), section.getBoolean(FORCE_PATH, defaults.isForce()));
    }

    public void spawnAt(Location location) {
        if (this.isValid()) {
            this.particle.spawn(location.getWorld(), location.getX(), location.getY(), location.getZ(), this.amount, this.deltaX, this.deltaY, this.deltaZ, this.speed, this.force);
        }
    }

    public boolean isValid() {
        return this.particle != null && this.particle.isValid();
    }

    public IParticle getParticle() {
        return this.particle;
    }

    public void setParticle(IParticle particle) {
        this.particle = particle;
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public void setDeltaX(double deltaX) {
        this.deltaX = deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public void setDeltaY(double deltaY) {
        this.deltaY = deltaY;
    }

    public double getDeltaZ() {
        return this.deltaZ;
    }

    public void setDeltaZ(double deltaZ) {
        this.deltaZ = deltaZ;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setIsForce(boolean force) {
        this.force = force;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.particle == null ? 0 : this.particle.hashCode());
        long temp = Double.doubleToLongBits(this.deltaX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.deltaY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.deltaZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.amount;
        temp = Double.doubleToLongBits(this.speed);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.force ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParticleConfiguration other = (ParticleConfiguration)obj;
        if (this.particle == null ? other.particle != null : !this.particle.equals(other.particle)) {
            return false;
        }
        if (Double.doubleToLongBits(this.deltaX) != Double.doubleToLongBits(other.deltaX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.deltaY) != Double.doubleToLongBits(other.deltaY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.deltaZ) != Double.doubleToLongBits(other.deltaZ)) {
            return false;
        }
        if (this.amount != other.amount) {
            return false;
        }
        if (Double.doubleToLongBits(this.speed) != Double.doubleToLongBits(other.speed)) {
            return false;
        }
        return this.force == other.force;
    }

    public String toString() {
        return this.isValid() ? String.format("%s\ndX: %.2f dY: %.2f dZ: %.2f\nAmount: %d\nSpeed: %.2f\nForce: %b", this.getParticle().toString(), this.getDeltaX(), this.getDeltaY(), this.getDeltaZ(), this.getAmount(), this.getSpeed(), this.isForce()) : "(None)";
    }
}

