/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.configuration.section.ParticleConfiguration;
import io.github.guillex7.explodeany.configuration.section.SoundConfiguration;
import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.configuration.ConfigurationSection;

public class EntityConfiguration {
    private static final String EXPLOSION_RADIUS_PATH = "ExplosionRadius";
    private static final String EXPLOSION_FACTOR_PATH = "ExplosionFactor";
    private static final String REPLACE_ORIGINAL_EXPLOSION_PATH = "ReplaceOriginalExplosion";
    private static final String UNDERWATER_EXPLOSION_FACTOR_PATH = "UnderwaterExplosionFactor";
    private static final String EXPLOSION_DAMAGE_BLOCKS_UNDERWATER_PATH = "ExplosionDamageBlocksUnderwater";
    private static final String REPLACE_ORIGINAL_EXPLOSION_WHEN_UNDERWATER = "ReplaceOriginalExplosionWhenUnderwater";
    private static final String EXPLOSION_REMOVE_WATERLOGGED_STATE_FROM_NEARBY_BLOCKS = "ExplosionRemoveWaterloggedStateFromNearbyBlocks";
    private static final String EXPLOSION_REMOVE_NEARBY_LIQUIDS = "ExplosionRemoveNearbyLiquids";
    private double explosionRadius;
    private double explosionFactor;
    private boolean replaceOriginalExplosion;
    private double underwaterExplosionFactor;
    private boolean explosionDamageBlocksUnderwater;
    private boolean replaceOriginalExplosionWhenUnderwater;
    private boolean explosionRemoveWaterloggedStateFromNearbyBlocks;
    private boolean explosionRemoveNearbyLiquid;
    private SoundConfiguration soundConfiguration;
    private ParticleConfiguration particleConfiguration;

    public static EntityConfiguration of(double explosionRadius, double explosionFactor, boolean replaceOriginalExplosion, double underwaterExplosionFactor, boolean explosionDamageBlocksUnderwater, boolean replaceOriginalExplosionWhenUnderwater, boolean explosionRemoveWaterloggedStateFromNearbyBlocks, boolean explosionRemoveNearbyLiquid, SoundConfiguration soundConfiguration, ParticleConfiguration particleConfiguration) {
        return new EntityConfiguration(explosionRadius, explosionFactor, replaceOriginalExplosion, underwaterExplosionFactor, explosionDamageBlocksUnderwater, replaceOriginalExplosionWhenUnderwater, explosionRemoveWaterloggedStateFromNearbyBlocks, explosionRemoveNearbyLiquid, soundConfiguration, particleConfiguration);
    }

    public static EntityConfiguration byDefault() {
        return EntityConfiguration.of(0.0, 1.0, false, 0.5, false, true, false, false, SoundConfiguration.byDefault(), ParticleConfiguration.byDefault());
    }

    public static EntityConfiguration fromConfigurationSection(ConfigurationSection section) {
        EntityConfiguration defaults = EntityConfiguration.byDefault();
        ConfigurationSection soundConfigurationSection = section.getConfigurationSection("Sound");
        ConfigurationSection particleConfigurationSection = section.getConfigurationSection("Particles");
        return EntityConfiguration.of(MathUtils.ensureMin(section.getDouble(EXPLOSION_RADIUS_PATH, defaults.getExplosionRadius()), 0.0), MathUtils.ensureMin(section.getDouble(EXPLOSION_FACTOR_PATH, defaults.getExplosionFactor()), 0.0), section.getBoolean(REPLACE_ORIGINAL_EXPLOSION_PATH, defaults.doReplaceOriginalExplosion()), MathUtils.ensureMin(section.getDouble(UNDERWATER_EXPLOSION_FACTOR_PATH, defaults.getUnderwaterExplosionFactor()), 0.0), section.getBoolean(EXPLOSION_DAMAGE_BLOCKS_UNDERWATER_PATH, defaults.doesExplosionDamageBlocksUnderwater()), section.getBoolean(REPLACE_ORIGINAL_EXPLOSION_WHEN_UNDERWATER, defaults.doReplaceOriginalExplosionWhenUnderwater()), section.getBoolean(EXPLOSION_REMOVE_WATERLOGGED_STATE_FROM_NEARBY_BLOCKS, defaults.doesExplosionRemoveWaterloggedStateFromNearbyBlocks()), section.getBoolean(EXPLOSION_REMOVE_NEARBY_LIQUIDS, defaults.doesExplosionRemoveNearbyLiquid()), soundConfigurationSection != null ? SoundConfiguration.fromConfigurationSection(soundConfigurationSection) : SoundConfiguration.byDefault(), particleConfigurationSection != null ? ParticleConfiguration.fromConfigurationSection(particleConfigurationSection) : ParticleConfiguration.byDefault());
    }

    public EntityConfiguration(double explosionRadius, double explosionFactor, boolean replaceOriginalExplosion, double underwaterExplosionFactor, boolean explosionDamageBlocksUnderwater, boolean replaceOriginalExplosionWhenUnderwater, boolean explosionRemoveWaterloggedStateFromNearbyBlocks, boolean explosionRemoveNearbyLiquid, SoundConfiguration soundConfiguration, ParticleConfiguration particleConfiguration) {
        this.explosionRadius = explosionRadius;
        this.explosionFactor = explosionFactor;
        this.replaceOriginalExplosion = replaceOriginalExplosion;
        this.underwaterExplosionFactor = underwaterExplosionFactor;
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
        this.replaceOriginalExplosionWhenUnderwater = replaceOriginalExplosionWhenUnderwater;
        this.explosionRemoveWaterloggedStateFromNearbyBlocks = explosionRemoveWaterloggedStateFromNearbyBlocks;
        this.explosionRemoveNearbyLiquid = explosionRemoveNearbyLiquid;
        this.soundConfiguration = soundConfiguration;
        this.particleConfiguration = particleConfiguration;
    }

    public double getExplosionRadius() {
        return this.explosionRadius;
    }

    public void setExplosionRadius(double explosionRadius) {
        this.explosionRadius = explosionRadius;
    }

    public double getExplosionFactor() {
        return this.explosionFactor;
    }

    public boolean doReplaceOriginalExplosion() {
        return this.replaceOriginalExplosion;
    }

    public void setReplaceOriginalExplosion(boolean replaceOriginalExplosion) {
        this.replaceOriginalExplosion = replaceOriginalExplosion;
    }

    public void setExplosionFactor(double explosionFactor) {
        this.explosionFactor = explosionFactor;
    }

    public double getUnderwaterExplosionFactor() {
        return this.underwaterExplosionFactor;
    }

    public void setUnderwaterExplosionFactor(double underwaterExplosionFactor) {
        this.underwaterExplosionFactor = underwaterExplosionFactor;
    }

    public boolean doesExplosionDamageBlocksUnderwater() {
        return this.explosionDamageBlocksUnderwater;
    }

    public void setExplosionDamageBlocksUnderwater(boolean explosionDamageBlocksUnderwater) {
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
    }

    public boolean doReplaceOriginalExplosionWhenUnderwater() {
        return this.replaceOriginalExplosionWhenUnderwater;
    }

    public void setReplaceOriginalExplosionWhenUnderwater(boolean replaceOriginalExplosionWhenUnderwater) {
        this.replaceOriginalExplosionWhenUnderwater = replaceOriginalExplosionWhenUnderwater;
    }

    public boolean doesExplosionRemoveWaterloggedStateFromNearbyBlocks() {
        return this.explosionRemoveWaterloggedStateFromNearbyBlocks;
    }

    public void setExplosionRemoveWaterloggedStateFromNearbyBlocks(boolean explosionRemoveWaterloggedStateFromNearbyBlocks) {
        this.explosionRemoveWaterloggedStateFromNearbyBlocks = explosionRemoveWaterloggedStateFromNearbyBlocks;
    }

    public boolean doesExplosionRemoveNearbyLiquid() {
        return this.explosionRemoveNearbyLiquid;
    }

    public void setExplosionRemoveNearbyLiquid(boolean explosionRemoveNearbyLiquid) {
        this.explosionRemoveNearbyLiquid = explosionRemoveNearbyLiquid;
    }

    public SoundConfiguration getSoundConfiguration() {
        return this.soundConfiguration;
    }

    public void setSoundConfiguration(SoundConfiguration soundConfiguration) {
        this.soundConfiguration = soundConfiguration;
    }

    public ParticleConfiguration getParticleConfiguration() {
        return this.particleConfiguration;
    }

    public void setParticleConfiguration(ParticleConfiguration particleConfiguration) {
        this.particleConfiguration = particleConfiguration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.explosionRadius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.explosionFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.replaceOriginalExplosion ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.underwaterExplosionFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.explosionDamageBlocksUnderwater ? 1231 : 1237);
        result = 31 * result + (this.replaceOriginalExplosionWhenUnderwater ? 1231 : 1237);
        result = 31 * result + (this.explosionRemoveWaterloggedStateFromNearbyBlocks ? 1231 : 1237);
        result = 31 * result + (this.explosionRemoveNearbyLiquid ? 1231 : 1237);
        result = 31 * result + (this.soundConfiguration == null ? 0 : this.soundConfiguration.hashCode());
        result = 31 * result + (this.particleConfiguration == null ? 0 : this.particleConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityConfiguration other = (EntityConfiguration)obj;
        if (Double.doubleToLongBits(this.explosionRadius) != Double.doubleToLongBits(other.explosionRadius)) {
            return false;
        }
        if (Double.doubleToLongBits(this.explosionFactor) != Double.doubleToLongBits(other.explosionFactor)) {
            return false;
        }
        if (this.replaceOriginalExplosion != other.replaceOriginalExplosion) {
            return false;
        }
        if (Double.doubleToLongBits(this.underwaterExplosionFactor) != Double.doubleToLongBits(other.underwaterExplosionFactor)) {
            return false;
        }
        if (this.explosionDamageBlocksUnderwater != other.explosionDamageBlocksUnderwater) {
            return false;
        }
        if (this.replaceOriginalExplosionWhenUnderwater != other.replaceOriginalExplosionWhenUnderwater) {
            return false;
        }
        if (this.explosionRemoveWaterloggedStateFromNearbyBlocks != other.explosionRemoveWaterloggedStateFromNearbyBlocks) {
            return false;
        }
        if (this.explosionRemoveNearbyLiquid != other.explosionRemoveNearbyLiquid) {
            return false;
        }
        if (this.soundConfiguration == null ? other.soundConfiguration != null : !this.soundConfiguration.equals(other.soundConfiguration)) {
            return false;
        }
        return !(this.particleConfiguration == null ? other.particleConfiguration != null : !this.particleConfiguration.equals(other.particleConfiguration));
    }

    public String toString() {
        return String.format("&7<General>\n&fExplosion radius: %.2f\n&fExplosion factor: %.2f\n&fReplace original explosion: %b\n&fUnderwater explosion factor: %.2f\n&fDamage blocks underwater: %b\n&fReplace underwater original explosion: %b\n&fRemove nearby waterlogged: %b\n&fRemove nearby liquids: %b\n\n&7<Sound>\n&f%s\n\n&7<Particle>\n&f%s", this.getExplosionRadius(), this.getExplosionFactor(), this.doReplaceOriginalExplosion(), this.getUnderwaterExplosionFactor(), this.doesExplosionDamageBlocksUnderwater(), this.doReplaceOriginalExplosionWhenUnderwater(), this.doesExplosionRemoveWaterloggedStateFromNearbyBlocks(), this.doesExplosionRemoveNearbyLiquid(), this.getSoundConfiguration().toString(), this.getParticleConfiguration().toString());
    }
}

