/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.command;

import io.github.guillex7.explodeany.command.registrable.RegistrableCommand;
import io.github.guillex7.explodeany.configuration.ConfigurationLocale;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.util.MessageFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class CommandManager
implements TabExecutor {
    private static CommandManager instance;
    private final Map<String, RegistrableCommand> registeredCommands = new HashMap<String, RegistrableCommand>();

    private CommandManager() {
    }

    public static CommandManager getInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public Map<String, RegistrableCommand> getRegisteredCommands() {
        return this.registeredCommands;
    }

    public void registerCommand(RegistrableCommand command) {
        this.registeredCommands.put(command.getName(), command);
    }

    public void unregisterAllCommands() {
        this.registeredCommands.clear();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        RegistrableCommand subcommand2;
        int i;
        RegistrableCommand rootCommand = this.getRegisteredCommands().get(command.getName());
        if (rootCommand == null) {
            return true;
        }
        StringBuilder breadcrumbsBuilder = new StringBuilder(rootCommand.getName());
        for (i = 0; i < args.length && (subcommand2 = rootCommand.getMappedSubcommands().get(args[i])) != null; ++i) {
            rootCommand = subcommand2;
            breadcrumbsBuilder.append(" ");
            breadcrumbsBuilder.append(rootCommand.getName());
        }
        if (!rootCommand.isCommandSenderAllowedToUse(sender)) {
            sender.sendMessage(ConfigurationManager.getInstance().getLocale(ConfigurationLocale.NOT_ALLOWED));
            return true;
        }
        if (!rootCommand.execute(sender, Arrays.copyOfRange(args, i, args.length))) {
            String usageDescription = "";
            if (!rootCommand.isTerminal()) {
                String possibleSubcommands = rootCommand.getSubcommands().stream().filter(subcommand -> subcommand.isCommandSenderAllowedToUse(sender)).map(RegistrableCommand::getName).reduce((subcommandAName, subcommandBName) -> subcommandAName + "/" + subcommandBName).orElse("no subcommand available");
                usageDescription = String.format("/%s &7<%s>", breadcrumbsBuilder.toString(), possibleSubcommands);
            } else {
                usageDescription = String.format("/%s &7%s", breadcrumbsBuilder.toString(), rootCommand.getUsage());
            }
            sender.sendMessage(ConfigurationManager.getInstance().getLocale(ConfigurationLocale.USAGE).replace("%DESCRIPTION%", MessageFormatter.colorize(usageDescription)));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        RegistrableCommand subcommand;
        int i;
        ArrayList<String> autocompletion = new ArrayList<String>();
        RegistrableCommand rootCommand = this.getRegisteredCommands().get(command.getName());
        if (rootCommand == null) {
            return autocompletion;
        }
        for (i = 0; i < args.length && (subcommand = rootCommand.getMappedSubcommands().get(args[i])) != null; ++i) {
            rootCommand = subcommand;
        }
        if (i >= args.length) {
            return autocompletion;
        }
        if (!rootCommand.isTerminal()) {
            String lastWrittenSubcommand = args[i];
            for (RegistrableCommand subcommand2 : rootCommand.getSubcommands()) {
                if (!subcommand2.isCommandSenderAllowedToUse(sender)) continue;
                subcommand2.getAllNames().stream().filter(x -> x.startsWith(lastWrittenSubcommand)).forEach(autocompletion::add);
            }
        } else if (rootCommand.isCommandSenderAllowedToUse(sender)) {
            rootCommand.onTabComplete(sender, Arrays.copyOfRange(args, i, args.length), autocompletion);
        }
        return autocompletion;
    }
}

