/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.block;

import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class BlockStatus {
    private Material material;
    private double durability;

    public static BlockStatus of(Material material, double durability) {
        return new BlockStatus(material, durability);
    }

    public static BlockStatus defaultForBlock(Block block) {
        return BlockStatus.of(block.getType(), BlockStatus.getDefaultBlockDurability());
    }

    public static double getDefaultBlockDurability() {
        return ConfigurationManager.getInstance().getBlockDurability();
    }

    private BlockStatus(Material material, double durability) {
        this.material = material;
        this.durability = durability;
    }

    public boolean isCongruentWith(Block block) {
        return block.getType().equals((Object)this.getMaterial());
    }

    public boolean damage(double damage) {
        this.setDurability(this.getDurability() - damage);
        return this.shouldBreak();
    }

    public boolean shouldBreak() {
        return this.getDurability() <= 0.0;
    }

    public void sanitize() {
        this.setDurability(MathUtils.ensureMax(this.getDurability(), BlockStatus.getDefaultBlockDurability()));
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public double getDurability() {
        return this.durability;
    }

    public void setDurability(double durability) {
        this.durability = durability;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.durability);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockStatus other = (BlockStatus)obj;
        if (Double.doubleToLongBits(this.durability) != Double.doubleToLongBits(other.durability)) {
            return false;
        }
        return this.material == other.material;
    }
}

