/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener.loadable.explosion;

import at.pavlov.cannons.event.ProjectileImpactEvent;
import at.pavlov.cannons.event.ProjectilePiercingEvent;
import at.pavlov.cannons.projectile.Projectile;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.LoadableConfigurationSection;
import io.github.guillex7.explodeany.configuration.section.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.explosion.ExplosionManager;
import io.github.guillex7.explodeany.listener.loadable.explosion.BaseExplosionListener;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public final class CannonExplosionListener
extends BaseExplosionListener {
    @Override
    public String getName() {
        return "Cannons explosions";
    }

    @Override
    public boolean isAnnounceable() {
        return true;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.NORMAL)
    public void onProjectileImpact(ProjectileImpactEvent event) {
        if (ConfigurationManager.getInstance().getDisabledWorlds().contains(event.getImpactLocation().getWorld().getName())) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (projectile == null) {
            return;
        }
        String projectileId = event.getProjectile().getProjectileId();
        Map<Material, EntityMaterialConfiguration> materialConfigurations = this.configuration.getEntityMaterialConfigurations().get(projectileId);
        if (materialConfigurations == null) {
            return;
        }
        EntityConfiguration entityConfiguration = this.configuration.getEntityConfigurations().get(projectileId);
        float explosionPower = projectile.getExplosionPower();
        if (ExplosionManager.getInstance().manageExplosion(materialConfigurations, entityConfiguration, event.getImpactLocation(), (int)explosionPower, explosionPower)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onProjectilePiercing(ProjectilePiercingEvent event) {
        if (ConfigurationManager.getInstance().getDisabledWorlds().contains(event.getImpactLocation().getWorld().getName())) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (projectile == null) {
            return;
        }
        Map<Material, EntityMaterialConfiguration> materialConfigurations = this.configuration.getEntityMaterialConfigurations().get(projectile.getProjectileId());
        if (materialConfigurations == null) {
            return;
        }
        Iterator iterator = event.getBlockList().iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            if (!materialConfigurations.containsKey(block.getType())) continue;
            event.setImpactLocation(block.getLocation());
            iterator.remove();
            break;
        }
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public void unload() {
        ProjectileImpactEvent.getHandlerList().unregister((Listener)this);
        ProjectilePiercingEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    protected LoadableConfigurationSection<?> getConfiguration() {
        return ConfigurationManager.getInstance().getRegisteredEntityConfiguration("CannonProjectile");
    }
}

