/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.explosion;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.block.BlockStatus;
import io.github.guillex7.explodeany.compat.common.api.IBlockDataUtils;
import io.github.guillex7.explodeany.compat.manager.CompatibilityManager;
import io.github.guillex7.explodeany.configuration.section.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.explosion.liquid.BlockLiquidDetector;
import io.github.guillex7.explodeany.explosion.liquid.TrajectoryExplosionLiquidDetector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ExplosionManager {
    private static ExplosionManager instance;
    public static final String EXPLOSION_MANAGER_SPAWNED_TAG = "eany-em-spawned";
    public static final String EXPLOSION_MANAGER_MATERIAL_CONFIGURATIONS_TAG = "eany-em-material-configurations";
    private final BlockLiquidDetector blockLiquidDetector = new BlockLiquidDetector();
    private final TrajectoryExplosionLiquidDetector trajectoryExplosionWaterDetector = new TrajectoryExplosionLiquidDetector();
    private final IBlockDataUtils blockDataUtils = CompatibilityManager.getInstance().getApi().getBlockDataUtils();

    private ExplosionManager() {
    }

    public static ExplosionManager getInstance() {
        if (instance == null) {
            instance = new ExplosionManager();
        }
        return instance;
    }

    public void removeHandledBlocksFromList(Map<Material, EntityMaterialConfiguration> materialConfigurations, List<Block> blockList) {
        Iterator<Block> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!materialConfigurations.containsKey(block.getType())) continue;
            iterator.remove();
        }
    }

    private void markEntityAsSpawnedByExplosionManager(Entity entity, Map<Material, EntityMaterialConfiguration> materialConfigurations) {
        entity.setMetadata(EXPLOSION_MANAGER_SPAWNED_TAG, (MetadataValue)new FixedMetadataValue((Plugin)ExplodeAny.getInstance(), (Object)true));
        entity.setMetadata(EXPLOSION_MANAGER_MATERIAL_CONFIGURATIONS_TAG, (MetadataValue)new FixedMetadataValue((Plugin)ExplodeAny.getInstance(), materialConfigurations));
    }

    public boolean isEntitySpawnedByExplosionManager(Entity entity) {
        return entity.hasMetadata(EXPLOSION_MANAGER_SPAWNED_TAG);
    }

    public Map<Material, EntityMaterialConfiguration> getMaterialConfigurationsFromEntity(Entity entity) {
        List metadataValueList = entity.getMetadata(EXPLOSION_MANAGER_MATERIAL_CONFIGURATIONS_TAG);
        if (!metadataValueList.isEmpty()) {
            return (Map)((MetadataValue)metadataValueList.get(0)).value();
        }
        return new HashMap<Material, EntityMaterialConfiguration>(0, 0.0f);
    }

    public boolean manageExplosion(Map<Material, EntityMaterialConfiguration> materialConfigurations, EntityConfiguration entityConfiguration, Location sourceLocation, int explosionRadius, float explosionPower) {
        int cx = sourceLocation.getBlockX();
        int cy = sourceLocation.getBlockY();
        int cz = sourceLocation.getBlockZ();
        int cxpr = cx + explosionRadius;
        int cypr = cy + explosionRadius;
        int czpr = cz + explosionRadius;
        int squaredExplosionRadius = explosionRadius * explosionRadius;
        World sourceWorld = sourceLocation.getWorld();
        ArrayList<Block> unhandledWaterloggedBlocks = new ArrayList<Block>(256);
        ArrayList<Block> liquidBlocks = new ArrayList<Block>(256);
        for (int x = cx - explosionRadius; x < cxpr; ++x) {
            for (int y = cy - explosionRadius; y < cypr; ++y) {
                for (int z = cz - explosionRadius; z < czpr; ++z) {
                    Block block;
                    int dx = x - cx;
                    int dy = y - cy;
                    int dz = z - cz;
                    int squaredDistance = dx * dx + dy * dy + dz * dz;
                    if (squaredExplosionRadius < squaredDistance || (block = sourceWorld.getBlockAt(x, y, z)).isEmpty()) continue;
                    EntityMaterialConfiguration materialConfiguration = materialConfigurations.get(block.getType());
                    if (materialConfiguration == null) {
                        if (this.blockDataUtils.isBlockWaterlogged(block)) {
                            unhandledWaterloggedBlocks.add(block);
                            continue;
                        }
                        if (!block.isLiquid()) continue;
                        liquidBlocks.add(block);
                        continue;
                    }
                    double effectiveSquaredExplosionRadius = (double)squaredExplosionRadius * materialConfiguration.getExplosionRadiusFactor();
                    if ((double)squaredDistance > effectiveSquaredExplosionRadius) continue;
                    this.damageBlock(materialConfiguration, block, sourceLocation, effectiveSquaredExplosionRadius, squaredDistance);
                }
            }
        }
        entityConfiguration.getSoundConfiguration().playAt(sourceLocation);
        entityConfiguration.getParticleConfiguration().spawnAt(sourceLocation);
        boolean isSourceLocationUnderwater = sourceLocation.getBlock().isLiquid();
        if (entityConfiguration.doesExplosionRemoveWaterloggedStateFromNearbyBlocks()) {
            for (Block unhandledWaterloggedBlock : unhandledWaterloggedBlocks) {
                this.blockDataUtils.setIsBlockWaterlogged(unhandledWaterloggedBlock, false);
            }
        }
        if (entityConfiguration.doesExplosionRemoveNearbyLiquid()) {
            for (Block liquidBlock : liquidBlocks) {
                liquidBlock.setType(Material.AIR);
            }
        }
        if (entityConfiguration.doesExplosionDamageBlocksUnderwater() && isSourceLocationUnderwater) {
            sourceLocation.getBlock().setType(Material.AIR);
            TNTPrimed explosiveEntity = (TNTPrimed)sourceWorld.spawn(sourceLocation, TNTPrimed.class);
            this.markEntityAsSpawnedByExplosionManager((Entity)explosiveEntity, materialConfigurations);
            explosiveEntity.setFuseTicks(0);
            explosiveEntity.setYield(explosionPower * entityConfiguration.getUnderwaterExplosionFactor().floatValue());
            return entityConfiguration.doReplaceOriginalExplosionWhenUnderwater();
        }
        return false;
    }

    private void damageBlock(EntityMaterialConfiguration materialConfiguration, Block targetBlock, Location sourceLocation, double squaredExplosionRadius, double squaredDistance) {
        double effectiveDamage = materialConfiguration.getDamage();
        if (materialConfiguration.isUnderwaterAffected() && this.areUnderwaterRulesApplicable(materialConfiguration, sourceLocation, targetBlock.getLocation())) {
            effectiveDamage *= materialConfiguration.getUnderwaterDamageFactor();
        }
        BlockStatus affectedBlockStatus = BlockDatabase.getInstance().getBlockStatus(targetBlock);
        affectedBlockStatus.damage(effectiveDamage *= 1.0 - materialConfiguration.getDistanceAttenuationFactor() * (squaredDistance - 1.0) / squaredExplosionRadius);
        if (affectedBlockStatus.shouldBreak()) {
            materialConfiguration.getSoundConfiguration().playAt(targetBlock.getLocation());
            materialConfiguration.getParticleConfiguration().spawnAt(targetBlock.getLocation());
            if (materialConfiguration.shouldBeDropped()) {
                targetBlock.breakNaturally();
            } else {
                targetBlock.setType(Material.AIR);
            }
            BlockDatabase.getInstance().removeBlockStatus(targetBlock);
        }
    }

    private boolean areUnderwaterRulesApplicable(EntityMaterialConfiguration materialConfiguration, Location sourceLocation, Location targetLocation) {
        return materialConfiguration.isFancyUnderwaterDetection() ? this.trajectoryExplosionWaterDetector.isLiquidInTrajectory(sourceLocation, targetLocation) : this.blockLiquidDetector.isBlockLiquidlike(sourceLocation);
    }
}

