/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;

public class SoundConfiguration {
    public static final String ROOT_PATH = "Sound";
    private static final String NAME_PATH = "Name";
    private static final String VOLUME_PATH = "Volume";
    private static final String PITCH_PATH = "Pitch";
    private Sound sound;
    private Double volume;
    private Double pitch;

    private SoundConfiguration(Sound sound, Double volume, Double pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static SoundConfiguration of(Sound sound, Double volume, Double pitch) {
        return new SoundConfiguration(sound, volume, pitch);
    }

    public static SoundConfiguration byDefault() {
        return SoundConfiguration.of(null, 1.0, 1.0);
    }

    public static SoundConfiguration fromConfigurationSection(ConfigurationSection section) {
        Sound sound;
        SoundConfiguration defaults = SoundConfiguration.byDefault();
        try {
            sound = Sound.valueOf((String)section.getString(NAME_PATH).toUpperCase());
        }
        catch (Exception e) {
            sound = null;
        }
        return SoundConfiguration.of(sound, MathUtils.ensureMin(section.getDouble(VOLUME_PATH, defaults.getVolume().doubleValue()), 0.0), MathUtils.ensureRange(section.getDouble(PITCH_PATH, defaults.getPitch().doubleValue()), 2.0, 0.5));
    }

    public void playAt(Location location) {
        location.getWorld().playSound(location, this.sound, this.volume.floatValue(), this.pitch.floatValue());
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public Double getVolume() {
        return this.volume;
    }

    public void setVolume(Double volume) {
        this.volume = volume;
    }

    public Double getPitch() {
        return this.pitch;
    }

    public void setPitch(Double pitch) {
        this.pitch = pitch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pitch == null ? 0 : this.pitch.hashCode());
        result = 31 * result + (this.sound == null ? 0 : this.sound.hashCode());
        result = 31 * result + (this.volume == null ? 0 : this.volume.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoundConfiguration other = (SoundConfiguration)obj;
        if (this.pitch == null ? other.pitch != null : !this.pitch.equals(other.pitch)) {
            return false;
        }
        if (this.sound != other.sound) {
            return false;
        }
        return !(this.volume == null ? other.volume != null : !this.volume.equals(other.volume));
    }

    public String toString() {
        return "SoundConfiguration [sound=" + this.sound + ", volume=" + this.volume + ", pitch=" + this.pitch + "]";
    }
}

