/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.configuration.section.ParticleConfiguration;
import io.github.guillex7.explodeany.configuration.section.SoundConfiguration;
import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.configuration.ConfigurationSection;

public class EntityConfiguration {
    private static final String EXPLOSION_DAMAGE_BLOCKS_UNDERWATER_PATH = "ExplosionDamageBlocksUnderwater";
    private static final String REPLACE_ORIGINAL_EXPLOSION_WHEN_UNDERWATER = "ReplaceOriginalExplosionWhenUnderwater";
    private static final String UNDERWATER_EXPLOSION_FACTOR_PATH = "UnderwaterExplosionFactor";
    private static final String EXPLOSION_REMOVE_WATERLOGGED_STATE_FROM_NEARBY_BLOCKS = "ExplosionRemoveWaterloggedStateFromNearbyBlocks";
    private static final String EXPLOSION_REMOVE_NEARBY_LIQUIDS = "ExplosionRemoveNearbyLiquids";
    private boolean explosionDamageBlocksUnderwater;
    private boolean replaceOriginalExplosionWhenUnderwater;
    private Double underwaterExplosionFactor;
    private boolean explosionRemoveWaterloggedStateFromNearbyBlocks;
    private boolean explosionRemoveNearbyLiquid;
    private SoundConfiguration soundConfiguration;
    private ParticleConfiguration particleConfiguration;

    public static EntityConfiguration of(boolean explosionDamageBlocksUnderwater, boolean replaceOriginalExplosionWhenUnderwater, Double underwaterExplosionFactor, boolean explosionRemoveWaterloggedStateFromNearbyBlocks, boolean explosionRemoveNearbyLiquid, SoundConfiguration soundConfiguration, ParticleConfiguration particleConfiguration) {
        return new EntityConfiguration(explosionDamageBlocksUnderwater, replaceOriginalExplosionWhenUnderwater, underwaterExplosionFactor, explosionRemoveWaterloggedStateFromNearbyBlocks, explosionRemoveNearbyLiquid, soundConfiguration, particleConfiguration);
    }

    public static EntityConfiguration byDefault() {
        return EntityConfiguration.of(false, true, 0.5, false, false, SoundConfiguration.byDefault(), ParticleConfiguration.byDefault());
    }

    public static EntityConfiguration fromConfigurationSection(ConfigurationSection section) {
        EntityConfiguration defaults = EntityConfiguration.byDefault();
        ConfigurationSection soundConfigurationSection = section.getConfigurationSection("Sound");
        ConfigurationSection particleConfigurationSection = section.getConfigurationSection("Particles");
        return EntityConfiguration.of(section.getBoolean(EXPLOSION_DAMAGE_BLOCKS_UNDERWATER_PATH, defaults.doesExplosionDamageBlocksUnderwater()), section.getBoolean(REPLACE_ORIGINAL_EXPLOSION_WHEN_UNDERWATER, defaults.doReplaceOriginalExplosionWhenUnderwater()), MathUtils.ensureMin(section.getDouble(UNDERWATER_EXPLOSION_FACTOR_PATH, defaults.getUnderwaterExplosionFactor().doubleValue()), 0.0), section.getBoolean(EXPLOSION_REMOVE_WATERLOGGED_STATE_FROM_NEARBY_BLOCKS, defaults.doesExplosionRemoveWaterloggedStateFromNearbyBlocks()), section.getBoolean(EXPLOSION_REMOVE_NEARBY_LIQUIDS, defaults.doesExplosionRemoveNearbyLiquid()), soundConfigurationSection != null ? SoundConfiguration.fromConfigurationSection(soundConfigurationSection) : SoundConfiguration.byDefault(), particleConfigurationSection != null ? ParticleConfiguration.fromConfigurationSection(particleConfigurationSection) : ParticleConfiguration.byDefault());
    }

    private EntityConfiguration(boolean explosionDamageBlocksUnderwater, boolean replaceOriginalExplosionWhenUnderwater, Double underwaterExplosionFactor, boolean explosionRemoveWaterloggedStateFromNearbyBlocks, boolean explosionRemoveNearbyLiquid, SoundConfiguration soundConfiguration, ParticleConfiguration particleConfiguration) {
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
        this.replaceOriginalExplosionWhenUnderwater = replaceOriginalExplosionWhenUnderwater;
        this.underwaterExplosionFactor = underwaterExplosionFactor;
        this.explosionRemoveWaterloggedStateFromNearbyBlocks = explosionRemoveWaterloggedStateFromNearbyBlocks;
        this.explosionRemoveNearbyLiquid = explosionRemoveNearbyLiquid;
        this.soundConfiguration = soundConfiguration;
        this.particleConfiguration = particleConfiguration;
    }

    public boolean doesExplosionDamageBlocksUnderwater() {
        return this.explosionDamageBlocksUnderwater;
    }

    public void setExplosionDamageBlocksUnderwater(boolean explosionDamageBlocksUnderwater) {
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
    }

    public boolean doReplaceOriginalExplosionWhenUnderwater() {
        return this.replaceOriginalExplosionWhenUnderwater;
    }

    public void setReplaceOriginalExplosionWhenUnderwater(boolean replaceOriginalExplosionWhenUnderwater) {
        this.replaceOriginalExplosionWhenUnderwater = replaceOriginalExplosionWhenUnderwater;
    }

    public Double getUnderwaterExplosionFactor() {
        return this.underwaterExplosionFactor;
    }

    public void setUnderwaterExplosionFactor(Double underwaterExplosionFactor) {
        this.underwaterExplosionFactor = underwaterExplosionFactor;
    }

    public boolean doesExplosionRemoveWaterloggedStateFromNearbyBlocks() {
        return this.explosionRemoveWaterloggedStateFromNearbyBlocks;
    }

    public void setExplosionRemoveWaterloggedStateFromNearbyBlocks(boolean explosionRemoveWaterloggedStateFromNearbyBlocks) {
        this.explosionRemoveWaterloggedStateFromNearbyBlocks = explosionRemoveWaterloggedStateFromNearbyBlocks;
    }

    public boolean doesExplosionRemoveNearbyLiquid() {
        return this.explosionRemoveNearbyLiquid;
    }

    public void setExplosionRemoveNearbyLiquid(boolean explosionRemoveNearbyLiquid) {
        this.explosionRemoveNearbyLiquid = explosionRemoveNearbyLiquid;
    }

    public SoundConfiguration getSoundConfiguration() {
        return this.soundConfiguration;
    }

    public void setSoundConfiguration(SoundConfiguration soundConfiguration) {
        this.soundConfiguration = soundConfiguration;
    }

    public ParticleConfiguration getParticleConfiguration() {
        return this.particleConfiguration;
    }

    public void setParticleConfiguration(ParticleConfiguration particleConfiguration) {
        this.particleConfiguration = particleConfiguration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.explosionDamageBlocksUnderwater ? 1231 : 1237);
        result = 31 * result + (this.replaceOriginalExplosionWhenUnderwater ? 1231 : 1237);
        result = 31 * result + (this.underwaterExplosionFactor == null ? 0 : this.underwaterExplosionFactor.hashCode());
        result = 31 * result + (this.explosionRemoveWaterloggedStateFromNearbyBlocks ? 1231 : 1237);
        result = 31 * result + (this.explosionRemoveNearbyLiquid ? 1231 : 1237);
        result = 31 * result + (this.soundConfiguration == null ? 0 : this.soundConfiguration.hashCode());
        result = 31 * result + (this.particleConfiguration == null ? 0 : this.particleConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityConfiguration other = (EntityConfiguration)obj;
        if (this.explosionDamageBlocksUnderwater != other.explosionDamageBlocksUnderwater) {
            return false;
        }
        if (this.replaceOriginalExplosionWhenUnderwater != other.replaceOriginalExplosionWhenUnderwater) {
            return false;
        }
        if (this.underwaterExplosionFactor == null ? other.underwaterExplosionFactor != null : !this.underwaterExplosionFactor.equals(other.underwaterExplosionFactor)) {
            return false;
        }
        if (this.explosionRemoveWaterloggedStateFromNearbyBlocks != other.explosionRemoveWaterloggedStateFromNearbyBlocks) {
            return false;
        }
        if (this.explosionRemoveNearbyLiquid != other.explosionRemoveNearbyLiquid) {
            return false;
        }
        if (this.soundConfiguration == null ? other.soundConfiguration != null : !this.soundConfiguration.equals(other.soundConfiguration)) {
            return false;
        }
        return !(this.particleConfiguration == null ? other.particleConfiguration != null : !this.particleConfiguration.equals(other.particleConfiguration));
    }

    public String toString() {
        return "EntityConfiguration [explosionDamageBlocksUnderwater=" + this.explosionDamageBlocksUnderwater + ", replaceOriginalExplosionWhenUnderwater=" + this.replaceOriginalExplosionWhenUnderwater + ", underwaterExplosionFactor=" + this.underwaterExplosionFactor + ", explosionRemoveWaterloggedStateFromNearbyBlocks=" + this.explosionRemoveWaterloggedStateFromNearbyBlocks + ", explosionRemoveNearbyLiquid=" + this.explosionRemoveNearbyLiquid + ", soundConfiguration=" + this.soundConfiguration + ", particleConfiguration=" + this.particleConfiguration + "]";
    }
}

