/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.compat.manager;

import io.github.guillex7.explodeany.compat.common.ICompatibilityApi;
import io.github.guillex7.explodeany.compat.common.Version;
import io.github.guillex7.explodeany.compat.v1_14.CompatibilityApi;
import org.bukkit.Bukkit;

public class CompatibilityManager {
    static CompatibilityManager instance;
    private final ICompatibilityApi[] registeredApis = new ICompatibilityApi[]{new CompatibilityApi(), new io.github.guillex7.explodeany.compat.v1_13.CompatibilityApi(), new io.github.guillex7.explodeany.compat.v1_9.CompatibilityApi(), new io.github.guillex7.explodeany.compat.v1_8.CompatibilityApi()};
    private ICompatibilityApi api;

    private CompatibilityManager() {
    }

    public static CompatibilityManager getInstance() {
        if (instance == null) {
            instance = new CompatibilityManager();
        }
        return instance;
    }

    public void loadMaximumApiForEnvironment() {
        this.api = this.getMaximumApiForEnvironment(this.getBukkitVersion());
        this.api.load();
    }

    private ICompatibilityApi getMaximumApiForEnvironment(Version bukkitVersion) {
        for (ICompatibilityApi api : this.registeredApis) {
            if (!bukkitVersion.isEqualOrAfter(api.getMinimumSupportedBukkitVersion())) continue;
            return api;
        }
        return this.registeredApis[this.registeredApis.length - 1];
    }

    public Version getBukkitVersion() {
        return Version.fromString(Bukkit.getVersion());
    }

    public ICompatibilityApi getApi() {
        return this.api;
    }
}

