/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.command.registrable;

import io.github.guillex7.explodeany.configuration.PermissionNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;

public abstract class RegistrableCommand {
    private Map<String, RegistrableCommand> mappedSubcommands = null;
    private Set<String> allNames = null;

    protected RegistrableCommand() {
        this.mapSubcommands();
        this.mapAllNames();
    }

    public abstract String getName();

    public Set<String> getAliases() {
        return new HashSet<String>();
    }

    public String getUsage() {
        return "";
    }

    public Set<PermissionNode> getRequiredPermissions() {
        return new HashSet<PermissionNode>();
    }

    public List<RegistrableCommand> getSubcommands() {
        return new ArrayList<RegistrableCommand>();
    }

    private final void mapSubcommands() {
        if (this.mappedSubcommands == null) {
            this.mappedSubcommands = new HashMap<String, RegistrableCommand>();
        } else {
            this.mappedSubcommands.clear();
        }
        for (RegistrableCommand subcommand : this.getSubcommands()) {
            this.mappedSubcommands.put(subcommand.getName(), subcommand);
            for (String subcommandAlias : subcommand.getAliases()) {
                this.mappedSubcommands.put(subcommandAlias, subcommand);
            }
        }
    }

    private final void mapAllNames() {
        if (this.allNames == null) {
            this.allNames = new HashSet<String>();
        } else {
            this.allNames.clear();
        }
        this.allNames.add(this.getName());
        this.allNames.addAll(this.getAliases());
    }

    public final Map<String, RegistrableCommand> getMappedSubcommands() {
        return this.mappedSubcommands;
    }

    public final Set<String> getAllNames() {
        return this.allNames;
    }

    public boolean execute(CommandSender sender, String[] args) {
        return false;
    }
}

