/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener.loadable.explosion;

import io.github.guillex7.explodeany.compat.common.api.IExplosionUtils;
import io.github.guillex7.explodeany.compat.manager.CompatibilityManager;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.section.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.explosion.ExplosionManager;
import io.github.guillex7.explodeany.listener.loadable.explosion.BaseExplosionListener;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public abstract class VanillaBaseExplosionListener
extends BaseExplosionListener {
    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent event) {
        WitherSkull witherSkull;
        if (!this.isEventHandled(event)) {
            return;
        }
        EntityType entityType = event.getEntityType();
        String entityTypeName = entityType.toString();
        boolean isCharged = false;
        Map<Material, EntityMaterialConfiguration> materialConfigurations = null;
        if (event.getEntityType().equals((Object)EntityType.CREEPER)) {
            Creeper creeper = (Creeper)event.getEntity();
            if (creeper.isPowered()) {
                entityTypeName = "CHARGED_".concat(entityTypeName);
                isCharged = true;
            }
        } else if (event.getEntityType().equals((Object)EntityType.WITHER_SKULL) && (witherSkull = (WitherSkull)event.getEntity()).isCharged()) {
            entityTypeName = "CHARGED_".concat(entityTypeName);
            isCharged = true;
        }
        materialConfigurations = this.configuration.getEntityMaterialConfigurations().get(entityTypeName);
        if (materialConfigurations == null) {
            return;
        }
        EntityConfiguration entityConfiguration = this.configuration.getEntityConfigurations().get(entityTypeName);
        IExplosionUtils.ExplosionParameters explosionParameters = CompatibilityManager.getInstance().getApi().getExplosionUtils().getExplosionRadiusAndPower(entityType, isCharged);
        if (!explosionParameters.areValid()) {
            return;
        }
        ExplosionManager.getInstance().removeHandledBlocksFromList(materialConfigurations, event.blockList());
        if (ExplosionManager.getInstance().manageExplosion(materialConfigurations, entityConfiguration, event.getLocation(), explosionParameters.getRadius(), explosionParameters.getPower())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void unload() {
        EntityExplodeEvent.getHandlerList().unregister((Listener)this);
    }

    protected boolean isEventHandled(EntityExplodeEvent event) {
        return event.getEntity() != null && !ConfigurationManager.getInstance().getDisabledWorlds().contains(event.getLocation().getWorld().getName());
    }
}

