/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.configuration.section.ParticleConfiguration;
import io.github.guillex7.explodeany.configuration.section.SoundConfiguration;
import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.configuration.ConfigurationSection;

public class EntityConfiguration {
    private static final String EXPLOSION_DAMAGE_BLOCKS_UNDERWATER_PATH = "ExplosionDamageBlocksUnderwater";
    private static final String UNDERWATER_EXPLOSION_FACTOR_PATH = "UnderwaterExplosionFactor";
    private boolean explosionDamageBlocksUnderwater;
    private Double underwaterExplosionFactor;
    private SoundConfiguration soundConfiguration;
    private ParticleConfiguration particleConfiguration;

    public static EntityConfiguration of(boolean explosionDamageBlocksUnderwater, Double underwaterExplosionFactor, SoundConfiguration soundConfiguration, ParticleConfiguration particleConfiguration) {
        return new EntityConfiguration(explosionDamageBlocksUnderwater, underwaterExplosionFactor, soundConfiguration, particleConfiguration);
    }

    public static EntityConfiguration byDefault() {
        return EntityConfiguration.of(false, 0.5, SoundConfiguration.byDefault(), ParticleConfiguration.byDefault());
    }

    public static EntityConfiguration fromConfigurationSection(ConfigurationSection section) {
        EntityConfiguration defaults = EntityConfiguration.byDefault();
        ConfigurationSection soundConfigurationSection = section.getConfigurationSection("Sound");
        ConfigurationSection particleConfigurationSection = section.getConfigurationSection("Particles");
        return EntityConfiguration.of(section.getBoolean(EXPLOSION_DAMAGE_BLOCKS_UNDERWATER_PATH, defaults.doesExplosionDamageBlocksUnderwater()), MathUtils.ensureMin(section.getDouble(UNDERWATER_EXPLOSION_FACTOR_PATH, defaults.getUnderwaterExplosionFactor().doubleValue()), 0.0), soundConfigurationSection != null ? SoundConfiguration.fromConfigurationSection(soundConfigurationSection) : SoundConfiguration.byDefault(), particleConfigurationSection != null ? ParticleConfiguration.fromConfigurationSection(particleConfigurationSection) : ParticleConfiguration.byDefault());
    }

    private EntityConfiguration(boolean explosionDamageBlocksUnderwater, Double underwaterExplosionFactor, SoundConfiguration soundConfiguration, ParticleConfiguration particleConfiguration) {
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
        this.underwaterExplosionFactor = underwaterExplosionFactor;
        this.soundConfiguration = soundConfiguration;
        this.particleConfiguration = particleConfiguration;
    }

    public boolean doesExplosionDamageBlocksUnderwater() {
        return this.explosionDamageBlocksUnderwater;
    }

    public void setExplosionDamageBlocksUnderwater(boolean explosionDamageBlocksUnderwater) {
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
    }

    public Double getUnderwaterExplosionFactor() {
        return this.underwaterExplosionFactor;
    }

    public void setUnderwaterExplosionFactor(Double underwaterExplosionFactor) {
        this.underwaterExplosionFactor = underwaterExplosionFactor;
    }

    public SoundConfiguration getSoundConfiguration() {
        return this.soundConfiguration;
    }

    public void setSoundConfiguration(SoundConfiguration soundConfiguration) {
        this.soundConfiguration = soundConfiguration;
    }

    public ParticleConfiguration getParticleConfiguration() {
        return this.particleConfiguration;
    }

    public void setParticleConfiguration(ParticleConfiguration particleConfiguration) {
        this.particleConfiguration = particleConfiguration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.explosionDamageBlocksUnderwater ? 1231 : 1237);
        result = 31 * result + (this.particleConfiguration == null ? 0 : this.particleConfiguration.hashCode());
        result = 31 * result + (this.soundConfiguration == null ? 0 : this.soundConfiguration.hashCode());
        result = 31 * result + (this.underwaterExplosionFactor == null ? 0 : this.underwaterExplosionFactor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityConfiguration other = (EntityConfiguration)obj;
        if (this.explosionDamageBlocksUnderwater != other.explosionDamageBlocksUnderwater) {
            return false;
        }
        if (this.particleConfiguration == null ? other.particleConfiguration != null : !this.particleConfiguration.equals(other.particleConfiguration)) {
            return false;
        }
        if (this.soundConfiguration == null ? other.soundConfiguration != null : !this.soundConfiguration.equals(other.soundConfiguration)) {
            return false;
        }
        return !(this.underwaterExplosionFactor == null ? other.underwaterExplosionFactor != null : !this.underwaterExplosionFactor.equals(other.underwaterExplosionFactor));
    }

    public String toString() {
        return "EntityConfiguration [explosionDamageBlocksUnderwater=" + this.explosionDamageBlocksUnderwater + ", underwaterExplosionFactor=" + this.underwaterExplosionFactor + ", soundConfiguration=" + this.soundConfiguration + ", particleConfiguration=" + this.particleConfiguration + "]";
    }
}

