/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.command.registrable.checktool;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ChecktoolManager {
    private static final String CHECKTOOL_DUMP_FILENAME = "checktool.dump";
    private static ChecktoolManager instance;
    private ItemStack checktool = this.getDefaultChecktool();
    private File checktoolFile = new File(this.getPlugin().getDataFolder(), "checktool.dump");
    private Set<Player> playersUsingChecktool = new HashSet<Player>();

    private ChecktoolManager() {
        this.loadChecktool();
    }

    public static ChecktoolManager getInstance() {
        if (instance == null) {
            instance = new ChecktoolManager();
        }
        return instance;
    }

    private ExplodeAny getPlugin() {
        return ExplodeAny.getInstance();
    }

    public Set<Player> getPlayersUsingChecktool() {
        return this.playersUsingChecktool;
    }

    private ItemStack getDefaultChecktool() {
        return new ItemStack(Material.AIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadChecktool() {
        block27: {
            if (this.checktoolFile.exists() && this.checktoolFile.canRead()) {
                FileInputStream inputStream = null;
                BukkitObjectInputStream objectInputStream = null;
                Logger configurationSerializationLogger = Logger.getLogger(ConfigurationSerialization.class.getName());
                Level previousConfigurationSerializationLevel = configurationSerializationLogger.getLevel();
                try {
                    inputStream = new FileInputStream(this.checktoolFile);
                    objectInputStream = new BukkitObjectInputStream((InputStream)inputStream);
                    configurationSerializationLogger.setLevel(Level.OFF);
                    this.checktool = (ItemStack)objectInputStream.readObject();
                    configurationSerializationLogger.setLevel(previousConfigurationSerializationLevel);
                    if (this.checktool != null && this.checktool.getType() != null) {
                        this.getPlugin().getLogger().info(String.format("Checktool item loaded successfully (%s)", StringUtils.beautifyName(this.checktool.getType().toString())));
                        break block27;
                    }
                    throw new ClassNotFoundException();
                }
                catch (IOException | ClassNotFoundException e) {
                    configurationSerializationLogger.setLevel(previousConfigurationSerializationLevel);
                    this.checktool = this.getDefaultChecktool();
                    this.getPlugin().getLogger().warning("Couldn't load checktool item! The item might belong to a higher Minecraft version or might be corrupted");
                }
                catch (Exception e) {
                    configurationSerializationLogger.setLevel(previousConfigurationSerializationLevel);
                    this.checktool = this.getDefaultChecktool();
                    this.getPlugin().getLogger().warning("Couldn't load checktool item! Unknown issue");
                }
                finally {
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (Exception e) {}
                    }
                    if (inputStream != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persistChecktool() {
        try {
            this.checktoolFile.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
        FileOutputStream outputStream = null;
        BukkitObjectOutputStream objectOutputStream = null;
        boolean checktoolWasPersistedSuccessfully = false;
        if (this.checktoolFile.exists() && this.checktoolFile.canWrite()) {
            try {
                outputStream = new FileOutputStream(this.checktoolFile);
                objectOutputStream = new BukkitObjectOutputStream((OutputStream)outputStream);
                objectOutputStream.writeObject((Object)this.checktool);
                checktoolWasPersistedSuccessfully = true;
            }
            catch (Exception e) {
                checktoolWasPersistedSuccessfully = false;
            }
            finally {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return checktoolWasPersistedSuccessfully;
    }

    public ItemStack getChecktool() {
        return this.checktool;
    }

    public boolean setChecktool(ItemStack item) {
        this.checktool = item;
        if (this.persistChecktool()) {
            this.getPlugin().getLogger().info("Checktool item persisted successfully!");
            return true;
        }
        this.getPlugin().getLogger().info("Checktool item was set, but it couldn't be persisted");
        return false;
    }
}

