/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.command;

import io.github.guillex7.explodeany.command.registrable.RegistrableCommand;
import io.github.guillex7.explodeany.configuration.ConfigurationLocale;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.PermissionNode;
import io.github.guillex7.explodeany.util.MessageFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class CommandManager
implements TabExecutor {
    private static CommandManager instance;
    private Map<String, RegistrableCommand> registeredCommands = new HashMap<String, RegistrableCommand>();

    private CommandManager() {
    }

    public static CommandManager getInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public Map<String, RegistrableCommand> getRegisteredCommands() {
        return this.registeredCommands;
    }

    public void registerCommand(RegistrableCommand command) {
        this.registeredCommands.put(command.getName(), command);
    }

    public void unregisterAllCommands() {
        this.registeredCommands.clear();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        RegistrableCommand subcommand;
        int i;
        RegistrableCommand rootCommand = this.getRegisteredCommands().get(command.getName());
        if (rootCommand == null) {
            return true;
        }
        String breadcrumbs = rootCommand.getName();
        for (i = 0; i < args.length && (subcommand = rootCommand.getMappedSubcommands().get(args[i])) != null; ++i) {
            rootCommand = subcommand;
            breadcrumbs = breadcrumbs + " " + rootCommand.getName();
        }
        boolean executable = true;
        for (PermissionNode permissionNode : rootCommand.getRequiredPermissions()) {
            if (sender.hasPermission(permissionNode.getKey())) continue;
            executable = false;
            break;
        }
        if (!executable) {
            sender.sendMessage(ConfigurationManager.getInstance().getLocale(ConfigurationLocale.NOT_ALLOWED));
            return true;
        }
        if (!rootCommand.execute(sender, Arrays.copyOfRange(args, i, args.length))) {
            sender.sendMessage(MessageFormatter.colorize(String.format("Usage: /%s &7%s", breadcrumbs, rootCommand.getUsage())));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        RegistrableCommand subcommand;
        int i;
        ArrayList<String> autocompletion = new ArrayList<String>();
        RegistrableCommand rootCommand = this.getRegisteredCommands().get(command.getName());
        if (rootCommand == null) {
            return autocompletion;
        }
        for (i = 0; i < args.length && (subcommand = rootCommand.getMappedSubcommands().get(args[i])) != null; ++i) {
            rootCommand = subcommand;
        }
        if (args.length <= i) {
            return autocompletion;
        }
        if (args[i].length() > 0) {
            for (RegistrableCommand subcommand2 : rootCommand.getSubcommands()) {
                if (!subcommand2.getName().startsWith(args[i])) continue;
                autocompletion.add(subcommand2.getName());
            }
        } else {
            for (RegistrableCommand subcommand3 : rootCommand.getSubcommands()) {
                autocompletion.add(subcommand3.getName());
            }
        }
        return autocompletion;
    }
}

