/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.block;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.block.BlockLocation;
import io.github.guillex7.explodeany.block.BlockLocationAdapter;
import io.github.guillex7.explodeany.block.BlockStatus;
import io.github.guillex7.explodeany.block.BlockStatusAdapter;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.gson.Gson;
import io.github.guillex7.explodeany.gson.GsonBuilder;
import io.github.guillex7.explodeany.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.block.Block;

public class BlockDatabase {
    private static BlockDatabase instance;
    private static final TypeToken<Map<BlockLocation, BlockStatus>> databaseTypeToken;
    private Map<BlockLocation, BlockStatus> database = new HashMap<BlockLocation, BlockStatus>();

    private static TypeToken<Map<BlockLocation, BlockStatus>> getDatabaseTypeToken() {
        return databaseTypeToken;
    }

    private BlockDatabase() {
    }

    public static BlockDatabase getInstance() {
        if (instance == null) {
            instance = new BlockDatabase();
        }
        return instance;
    }

    private ExplodeAny getPlugin() {
        return ExplodeAny.getInstance();
    }

    private Map<BlockLocation, BlockStatus> getDatabase() {
        return this.database;
    }

    private void setDatabase(Map<BlockLocation, BlockStatus> database) {
        this.database = database;
    }

    public BlockStatus getBlockStatus(Block block) {
        return this.getBlockStatus(block, true);
    }

    public BlockStatus getBlockStatus(Block block, Boolean persistIfAbsentOrIncongruent) {
        BlockLocation blockLocation = BlockLocation.fromBlock(block);
        BlockStatus blockStatus = this.getDatabase().get(blockLocation);
        if (blockStatus == null || !blockStatus.isCongruentWith(block)) {
            blockStatus = BlockStatus.defaultForBlock(block);
            if (persistIfAbsentOrIncongruent.booleanValue()) {
                this.getDatabase().put(blockLocation, blockStatus);
            }
        }
        return blockStatus;
    }

    public void removeBlockStatus(Block block) {
        this.getDatabase().remove(BlockLocation.fromBlock(block));
    }

    public void loadFromFile(File databaseFile) {
        if (!databaseFile.exists() || !databaseFile.canRead()) {
            this.getPlugin().getLogger().info("Database doesn't exist yet, will create a new database");
            return;
        }
        this.setDatabase(this.deserializeDatabaseFile(databaseFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BlockLocation, BlockStatus> deserializeDatabaseFile(File databaseFile) {
        Map<BlockLocation, BlockStatus> loadedDatabase;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(databaseFile);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockLocation.class), new BlockLocationAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockStatus.class), new BlockStatusAdapter());
            gsonBuilder.enableComplexMapKeySerialization();
            Gson gson = gsonBuilder.create();
            loadedDatabase = (Map)gson.fromJson((Reader)fileReader, BlockDatabase.getDatabaseTypeToken().getType());
            if (loadedDatabase == null) {
                throw new Exception();
            }
            this.getPlugin().getLogger().info("Database loaded successfully");
        }
        catch (Exception e) {
            loadedDatabase = new HashMap<BlockLocation, BlockStatus>();
            this.getPlugin().getLogger().warning("Couldn't load database, creating an empty one");
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return loadedDatabase;
    }

    public void saveToFile(File databaseFile) {
        if (!databaseFile.exists()) {
            try {
                databaseFile.createNewFile();
            }
            catch (IOException e) {
                this.getPlugin().getLogger().warning("Couldn't create a new database file! Database won't be saved");
                return;
            }
        }
        this.serializeDatabaseFile(databaseFile, this.getDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeDatabaseFile(File databaseFile, Map<BlockLocation, BlockStatus> database) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(databaseFile);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockLocation.class), new BlockLocationAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockStatus.class), new BlockStatusAdapter());
            gsonBuilder.enableComplexMapKeySerialization();
            Gson gson = gsonBuilder.create();
            fileWriter.write(gson.toJson(database, BlockDatabase.getDatabaseTypeToken().getType()));
            this.getPlugin().getLogger().info("Database saved successfully");
        }
        catch (Exception e) {
            this.getPlugin().getLogger().warning("Couldn't save database");
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void sanitize() {
        Iterator<Map.Entry<BlockLocation, BlockStatus>> iterator = this.getDatabase().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockLocation, BlockStatus> entry = iterator.next();
            if (!this.isEntryNotSane(entry, ConfigurationManager.getInstance().doCheckBlockDatabaseAtStartup())) continue;
            iterator.remove();
        }
    }

    private boolean isEntryNotSane(Map.Entry<BlockLocation, BlockStatus> entry, boolean deep) {
        BlockStatus blockStatus = entry.getValue();
        if (blockStatus.shouldBreak()) {
            return true;
        }
        blockStatus.sanitize();
        if (deep) {
            Block block = entry.getKey().toBlock();
            return block.isEmpty() || !ConfigurationManager.getInstance().handlesBlock(block) || !blockStatus.isCongruentWith(block);
        }
        return false;
    }

    static {
        databaseTypeToken = new TypeToken<Map<BlockLocation, BlockStatus>>(){};
    }
}

