/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany;

import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.bstats.bukkit.Metrics;
import io.github.guillex7.explodeany.command.CommandManager;
import io.github.guillex7.explodeany.command.registrable.CommandEany;
import io.github.guillex7.explodeany.command.registrable.RegistrableCommand;
import io.github.guillex7.explodeany.compat.manager.CompatibilityManager;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.CannonProjectileConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.MagicEntityConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.VanillaEntityConfiguration;
import io.github.guillex7.explodeany.listener.ListenerManager;
import io.github.guillex7.explodeany.listener.loadable.BlockListener;
import io.github.guillex7.explodeany.listener.loadable.EntityListener;
import io.github.guillex7.explodeany.listener.loadable.explosion.CannonExplosionListener;
import io.github.guillex7.explodeany.listener.loadable.explosion.MagicExplosionListener;
import io.github.guillex7.explodeany.listener.loadable.explosion.VanillaExplosionListener;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public class ExplodeAny
extends JavaPlugin {
    private static final String DATABASE_FILENAME = "blockDatabase.json";
    private static final int METRICS_PLUGIN_ID = 18111;
    private ConfigurationManager configurationManager;
    private BlockDatabase blockDatabase;
    private ListenerManager listenerManager;
    private CommandManager commandManager;
    private Metrics metrics;
    private CompatibilityManager compatibilityManager;

    public void onEnable() {
        super.onEnable();
        this.compatibilityManager = CompatibilityManager.getInstance();
        this.configurationManager = ConfigurationManager.getInstance();
        this.blockDatabase = BlockDatabase.getInstance();
        this.listenerManager = ListenerManager.getInstance();
        this.commandManager = CommandManager.getInstance();
        this.getLogger().info(String.format("%s v%s is loading now!", this.getDescription().getName(), this.getDescription().getVersion()));
        this.loadCompatibilityLayer();
        this.announceCompatibility();
        this.loadConfiguration();
        this.loadDatabase();
        this.registerListeners();
        this.registerCommands();
        this.peekMetrics();
    }

    public void onDisable() {
        super.onDisable();
        this.getLogger().info(String.format("%s v%s is unloading now!", this.getDescription().getName(), this.getDescription().getVersion()));
        this.unregisterListeners();
        this.unloadDatabase();
        this.unloadConfiguration();
        this.shutdownMetrics();
    }

    public void loadCompatibilityLayer() {
        this.compatibilityManager.loadMaximumApiForEnvironment();
    }

    public void announceCompatibility() {
        this.getLogger().info(String.format("Compatibility layer for Bukkit v%s+ (detected Bukkit version: %s)", this.compatibilityManager.getApi().getMinimumSupportedBukkitVersion(), this.compatibilityManager.getBukkitVersion()));
    }

    public void loadConfiguration() {
        this.configurationManager.loadConfiguration();
        this.configurationManager.registerEntityConfiguration(new VanillaEntityConfiguration());
        this.configurationManager.registerEntityConfiguration(new CannonProjectileConfiguration());
        this.configurationManager.registerEntityConfiguration(new MagicEntityConfiguration());
        this.configurationManager.loadAllEntityConfigurations();
    }

    public void loadDatabase() {
        if (this.configurationManager.doUseBlockDatabase()) {
            this.blockDatabase.loadFromFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
            this.blockDatabase.sanitize();
            this.unloadDatabase();
        }
    }

    public void registerListeners() {
        this.listenerManager.registerListener(new BlockListener());
        this.listenerManager.registerListener(new EntityListener());
        this.listenerManager.registerListener(new VanillaExplosionListener());
        this.listenerManager.registerListener(new CannonExplosionListener());
        this.listenerManager.registerListener(new MagicExplosionListener());
        this.listenerManager.loadAllListeners();
    }

    public void registerCommands() {
        this.commandManager.registerCommand(new CommandEany());
        for (RegistrableCommand command : this.commandManager.getRegisteredCommands().values()) {
            this.getCommand(command.getName()).setExecutor((CommandExecutor)this.commandManager);
        }
    }

    public void peekMetrics() {
        if (this.configurationManager.doEnableMetrics()) {
            this.metrics = new Metrics(this, this.getMetricsPluginId());
            this.getLogger().info("Metrics have been enabled");
        }
    }

    public void unloadConfiguration() {
        this.configurationManager.unloadAllEntityConfigurations();
    }

    public void unloadDatabase() {
        if (this.configurationManager.doUseBlockDatabase()) {
            this.blockDatabase.saveToFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
        }
    }

    public void unregisterListeners() {
        this.listenerManager.unloadAllListeners();
        this.listenerManager.unregisterAllListeners();
    }

    public void shutdownMetrics() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        this.metrics = null;
    }

    public String getDatabaseFilename() {
        return DATABASE_FILENAME;
    }

    public int getMetricsPluginId() {
        return 18111;
    }

    public static ExplodeAny getInstance() {
        return (ExplodeAny)JavaPlugin.getPlugin(ExplodeAny.class);
    }
}

