/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener.loadable;

import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.LoadableSectionConfiguration;
import io.github.guillex7.explodeany.explosion.ExplosionManager;
import io.github.guillex7.explodeany.listener.loadable.LoadableListener;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public final class VanillaExplosionListener
implements LoadableListener {
    private VanillaExplosionListener() {
    }

    public static VanillaExplosionListener empty() {
        return new VanillaExplosionListener();
    }

    @Override
    public String getName() {
        return "Vanilla explosions";
    }

    @Override
    public boolean shouldBeLoaded() {
        return ConfigurationManager.getInstance().getRegisteredEntityConfiguration("VanillaEntity").shouldBeLoaded();
    }

    @Override
    public boolean isAdvisable() {
        return true;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent event) {
        LoadableSectionConfiguration<?> vanillaEntityConfiguration;
        WitherSkull witherSkull;
        if (event.getEntity() == null) {
            return;
        }
        String entityTypeName = event.getEntityType().toString();
        boolean isCharged = false;
        Map<Material, EntityMaterialConfiguration> materialConfigurations = null;
        if (event.getEntityType().equals((Object)EntityType.CREEPER)) {
            Creeper creeper = (Creeper)event.getEntity();
            if (creeper.isPowered()) {
                entityTypeName = "CHARGED_".concat(entityTypeName);
                isCharged = true;
            }
        } else if (event.getEntityType().equals((Object)EntityType.WITHER_SKULL) && (witherSkull = (WitherSkull)event.getEntity()).isCharged()) {
            entityTypeName = "CHARGED_".concat(entityTypeName);
            isCharged = true;
        }
        if ((materialConfigurations = (vanillaEntityConfiguration = ConfigurationManager.getInstance().getRegisteredEntityConfiguration("VanillaEntity")).getEntityMaterialConfigurations().get(entityTypeName)) == null) {
            return;
        }
        EntityConfiguration entityConfiguration = vanillaEntityConfiguration.getEntityConfigurations().get(entityTypeName);
        int explosionRadius = 0;
        float explosionPower = 0.0f;
        switch (event.getEntityType()) {
            case WITHER: {
                explosionRadius = 7;
                explosionPower = 7.0f;
                break;
            }
            case ENDER_CRYSTAL: {
                explosionRadius = 6;
                explosionPower = 6.0f;
                break;
            }
            case PRIMED_TNT: {
                explosionRadius = 4;
                explosionPower = 4.0f;
                break;
            }
            case CREEPER: {
                explosionRadius = isCharged ? 4 : 3;
                explosionPower = isCharged ? 6.0f : 3.0f;
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: 
            case WITHER_SKULL: 
            case DRAGON_FIREBALL: {
                explosionRadius = 1;
                explosionPower = 1.0f;
                break;
            }
        }
        if (explosionRadius <= 0) {
            return;
        }
        ExplosionManager.getInstance().removeHandledBlocksFromList(materialConfigurations, event.blockList());
        if (ExplosionManager.getInstance().manageExplosion(materialConfigurations, entityConfiguration, event.getLocation(), explosionRadius, explosionPower)) {
            event.setCancelled(true);
        }
    }

    @Override
    public void unload() {
        EntityExplodeEvent.getHandlerList().unregister((Listener)this);
    }
}

