/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.listener.loadable.LoadableListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ListenerManager {
    private static ListenerManager instance;
    private List<LoadableListener> registeredListeners = new ArrayList<LoadableListener>();

    private ListenerManager() {
    }

    public static ListenerManager getInstance() {
        if (instance == null) {
            instance = new ListenerManager();
        }
        return instance;
    }

    public List<LoadableListener> getRegisteredListeners() {
        return this.registeredListeners;
    }

    public void registerListener(LoadableListener explosionListener) {
        this.getRegisteredListeners().add(explosionListener);
    }

    public void unloadAllListeners() {
        for (LoadableListener explosionListener : this.getRegisteredListeners()) {
            if (!explosionListener.shouldBeLoaded()) continue;
            explosionListener.unload();
        }
        this.getRegisteredListeners().clear();
    }

    public void loadAllListeners() {
        for (LoadableListener listener : this.getRegisteredListeners()) {
            if (!listener.shouldBeLoaded()) continue;
            Bukkit.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)ExplodeAny.getInstance());
            if (!listener.isAdvisable()) continue;
            this.getLogger().log(Level.INFO, String.format("Enabled support for %s", listener.getName()));
        }
    }

    private Logger getLogger() {
        return ExplodeAny.getInstance().getLogger();
    }
}

