/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.loadable;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.EntityMaterialConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class LoadableSectionConfiguration<T> {
    private static final String MATERIALS_SECTION = "Materials";
    private static final String PROPERTIES_SECTION = "Properties";
    private Map<T, Map<Material, EntityMaterialConfiguration>> entityMaterialConfigurations = new HashMap<T, Map<Material, EntityMaterialConfiguration>>();
    private Map<T, EntityConfiguration> entityConfigurations = new HashMap<T, EntityConfiguration>();

    protected LoadableSectionConfiguration() {
    }

    public abstract String getEntityName(T var1);

    public abstract String getSectionPath();

    public abstract T getEntityFromName(String var1);

    public abstract boolean checkEntityTypeIsValid(T var1);

    public boolean shouldBeLoaded() {
        return true;
    }

    private final ExplodeAny getPlugin() {
        return ExplodeAny.getInstance();
    }

    public final Map<T, Map<Material, EntityMaterialConfiguration>> getEntityMaterialConfigurations() {
        return this.entityMaterialConfigurations;
    }

    public final Map<T, EntityConfiguration> getEntityConfigurations() {
        return this.entityConfigurations;
    }

    public final void putAndMergeEntityMaterialConfigurations(T entity, Map<Material, EntityMaterialConfiguration> materialConfigurations, boolean definitionHasPriority) {
        if (!this.entityMaterialConfigurations.containsKey(entity)) {
            this.entityMaterialConfigurations.put(entity, materialConfigurations);
        } else if (definitionHasPriority) {
            this.entityMaterialConfigurations.get(entity).putAll(materialConfigurations);
        } else {
            for (Material material : materialConfigurations.keySet()) {
                this.entityMaterialConfigurations.get(entity).putIfAbsent(material, materialConfigurations.get(material));
            }
        }
    }

    public final void putAndMergeEntityConfigurations(T entity, EntityConfiguration entityConfiguration, boolean definitionHasPriority) {
        if (definitionHasPriority) {
            this.getEntityConfigurations().put(entity, entityConfiguration);
        } else {
            this.getEntityConfigurations().putIfAbsent(entity, entityConfiguration);
        }
    }

    public final void putAndMergeMaterialConfigurations(Map<Material, EntityMaterialConfiguration> materialConfigurations, Material material, EntityMaterialConfiguration entityMaterialConfiguration, boolean definitionHasPriority) {
        if (definitionHasPriority) {
            materialConfigurations.put(material, entityMaterialConfiguration);
        } else {
            materialConfigurations.putIfAbsent(material, entityMaterialConfiguration);
        }
    }

    public final void clearEntityMaterialConfigurations() {
        this.entityMaterialConfigurations.clear();
    }

    public final void fetchEntityMaterialConfigurations(FileConfiguration config) {
        this.fetchEntities(config.getConfigurationSection(this.getSectionPath()));
    }

    private final void fetchEntities(ConfigurationSection entitiesSection) {
        for (String entityName : entitiesSection.getKeys(false)) {
            ArrayList<T> fetchedEntities = new ArrayList<T>();
            boolean definitionHasPriority = true;
            T entity = this.getEntityFromName(entityName);
            if (this.checkEntityTypeIsValid(entity)) {
                fetchedEntities.add(entity);
            } else {
                definitionHasPriority = false;
                List<String> entityGroup = ConfigurationManager.getInstance().getGroups().get(entityName);
                if (entityGroup != null) {
                    for (String entityNameInGroup : entityGroup) {
                        T entityInGroup = this.getEntityFromName(entityNameInGroup);
                        if (!this.checkEntityTypeIsValid(entityInGroup)) continue;
                        fetchedEntities.add(entityInGroup);
                    }
                }
            }
            if (fetchedEntities.isEmpty()) {
                this.getPlugin().getLogger().log(Level.WARNING, String.format("%s is not a valid %s nor %s group and won't be loaded", entityName, this.getSectionPath(), this.getSectionPath()));
                continue;
            }
            ConfigurationSection entitySection = entitiesSection.getConfigurationSection(entityName);
            if (entitySection == null) {
                this.getPlugin().getLogger().log(Level.WARNING, String.format("%s.%s section is invalid and won't be loaded", this.getSectionPath(), entityName));
                continue;
            }
            Map<Object, Object> materialConfigurations = new HashMap();
            EntityConfiguration entityConfiguration = EntityConfiguration.byDefault();
            ConfigurationSection materialsSection = entitySection.getConfigurationSection(MATERIALS_SECTION);
            ConfigurationSection propertiesSection = entitySection.getConfigurationSection(PROPERTIES_SECTION);
            boolean hasSections = false;
            if (materialsSection != null) {
                materialConfigurations = this.fetchMaterials(materialsSection);
                hasSections = true;
            }
            if (propertiesSection != null) {
                entityConfiguration = EntityConfiguration.fromConfigurationSection(propertiesSection);
                hasSections = true;
            }
            if (!hasSections) {
                materialConfigurations = this.fetchMaterials(entitySection);
            }
            for (Object fetchedEntity : fetchedEntities) {
                this.putAndMergeEntityConfigurations(fetchedEntity, entityConfiguration, definitionHasPriority);
                this.putAndMergeEntityMaterialConfigurations(fetchedEntity, new HashMap<Material, EntityMaterialConfiguration>(materialConfigurations), definitionHasPriority);
            }
        }
    }

    private final Material getMaterialFromName(String name) {
        Material material;
        try {
            material = Material.valueOf((String)name);
        }
        catch (Exception e) {
            material = null;
        }
        return material;
    }

    private final boolean checkMaterialIsValid(Material material) {
        return material != null && !material.equals((Object)Material.WATER) && !material.equals((Object)Material.LAVA);
    }

    private final Map<Material, EntityMaterialConfiguration> fetchMaterials(ConfigurationSection entitySection) {
        HashMap<Material, EntityMaterialConfiguration> materialConfigurations = new HashMap<Material, EntityMaterialConfiguration>();
        for (String materialName : entitySection.getKeys(false)) {
            ArrayList<Material> fetchedMaterials = new ArrayList<Material>();
            boolean definitionHasPriority = true;
            Material material = this.getMaterialFromName(materialName);
            if (this.checkMaterialIsValid(material)) {
                fetchedMaterials.add(this.getMaterialFromName(materialName));
            } else {
                definitionHasPriority = false;
                List<String> materialGroup = ConfigurationManager.getInstance().getGroups().get(materialName);
                if (materialGroup != null) {
                    for (String materialNameInGroup : materialGroup) {
                        Material materialInGroup = this.getMaterialFromName(materialNameInGroup);
                        if (!this.checkMaterialIsValid(materialInGroup)) continue;
                        fetchedMaterials.add(materialInGroup);
                    }
                }
            }
            if (fetchedMaterials.isEmpty()) {
                this.getPlugin().getLogger().log(Level.WARNING, String.format("%s is an invalid material or material group for %s and won't be loaded", materialName, entitySection.getName()));
                continue;
            }
            ConfigurationSection materialSection = entitySection.getConfigurationSection(materialName);
            if (materialSection == null) {
                this.getPlugin().getLogger().log(Level.WARNING, String.format("%s.%s.%s is invalid and won't be loaded", this.getSectionPath(), entitySection.getName(), materialName));
                continue;
            }
            EntityMaterialConfiguration entityMaterialConfiguration = EntityMaterialConfiguration.fromConfigurationSection(materialSection);
            for (Material fetchedMaterial : fetchedMaterials) {
                this.putAndMergeMaterialConfigurations(materialConfigurations, fetchedMaterial, entityMaterialConfiguration, definitionHasPriority);
            }
        }
        return materialConfigurations;
    }
}

