/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.loadable;

import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import org.bukkit.configuration.ConfigurationSection;

public class EntityMaterialConfiguration {
    private static final String DAMAGE_PATH = "Damage";
    private static final String DROP_CHANCE_PATH = "DropChance";
    private static final String DISTANCE_ATTENUATION_FACTOR_PATH = "DistanceAttenuationFactor";
    private static final String EXPLOSION_RADIUS_FACTOR_PATH = "ExplosionRadiusFactor";
    private static final String UNDERWATER_DAMAGE_FACTOR_PATH = "UnderwaterDamageFactor";
    private static final String FANCY_UNDERWATER_DETECTION_PATH = "FancyUnderwaterDetection";
    private double damage;
    private double dropChance;
    private double distanceAttenuationFactor;
    private double explosionRadiusFactor;
    private double underwaterDamageFactor;
    private boolean fancyUnderwaterDetection;

    public static EntityMaterialConfiguration of(double damage, double dropChance, double distanceAttenuationFactor, double explosionRadiusFactor, double underwaterDamageFactor, boolean fancyUnderwaterDetection) {
        return new EntityMaterialConfiguration(damage, dropChance, distanceAttenuationFactor, explosionRadiusFactor, underwaterDamageFactor, fancyUnderwaterDetection);
    }

    public static EntityMaterialConfiguration fromConfigurationSection(ConfigurationSection section) {
        return EntityMaterialConfiguration.of(ConfigurationManager.ensureMin(section.getDouble(DAMAGE_PATH, ConfigurationManager.getInstance().getBlockDurability().doubleValue()), 0.0), ConfigurationManager.ensureRange(section.getDouble(DROP_CHANCE_PATH, 0.0), 100.0, 0.0) / 100.0, ConfigurationManager.ensureRange(section.getDouble(DISTANCE_ATTENUATION_FACTOR_PATH, 0.0), 1.0, 0.0), ConfigurationManager.ensureMin(section.getDouble(EXPLOSION_RADIUS_FACTOR_PATH, 0.5), 0.0), ConfigurationManager.ensureMin(section.getDouble(UNDERWATER_DAMAGE_FACTOR_PATH, 0.5), 0.0), section.getBoolean(FANCY_UNDERWATER_DETECTION_PATH, false));
    }

    private EntityMaterialConfiguration(double damage, double dropChance, double distanceAttenuationFactor, double explosionRadiusFactor, double underwaterDamageFactor, boolean fancyUnderwaterDetection) {
        this.damage = damage;
        this.dropChance = dropChance;
        this.distanceAttenuationFactor = distanceAttenuationFactor;
        this.explosionRadiusFactor = explosionRadiusFactor;
        this.underwaterDamageFactor = underwaterDamageFactor;
        this.fancyUnderwaterDetection = fancyUnderwaterDetection;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public boolean shouldBeDropped() {
        return Math.random() <= this.getDropChance();
    }

    public double getDistanceAttenuationFactor() {
        return this.distanceAttenuationFactor;
    }

    public double getExplosionRadiusFactor() {
        return this.explosionRadiusFactor;
    }

    public double getUnderwaterDamageFactor() {
        return this.underwaterDamageFactor;
    }

    public boolean isUnderwaterAffected() {
        return this.getUnderwaterDamageFactor() != 1.0;
    }

    public boolean isFancyUnderwaterDetection() {
        return this.fancyUnderwaterDetection;
    }

    public void setFancyUnderwaterDetection(boolean fancyUnderwaterDetection) {
        this.fancyUnderwaterDetection = fancyUnderwaterDetection;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.damage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.distanceAttenuationFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.dropChance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.explosionRadiusFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.fancyUnderwaterDetection ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.underwaterDamageFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityMaterialConfiguration other = (EntityMaterialConfiguration)obj;
        if (Double.doubleToLongBits(this.damage) != Double.doubleToLongBits(other.damage)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distanceAttenuationFactor) != Double.doubleToLongBits(other.distanceAttenuationFactor)) {
            return false;
        }
        if (Double.doubleToLongBits(this.dropChance) != Double.doubleToLongBits(other.dropChance)) {
            return false;
        }
        if (Double.doubleToLongBits(this.explosionRadiusFactor) != Double.doubleToLongBits(other.explosionRadiusFactor)) {
            return false;
        }
        if (this.fancyUnderwaterDetection != other.fancyUnderwaterDetection) {
            return false;
        }
        return Double.doubleToLongBits(this.underwaterDamageFactor) == Double.doubleToLongBits(other.underwaterDamageFactor);
    }

    public String toString() {
        return "EntityMaterialConfiguration [d=" + this.damage + ", dC=" + this.dropChance + ", dAF=" + this.distanceAttenuationFactor + ", eRF=" + this.explosionRadiusFactor + ", uDF=" + this.underwaterDamageFactor + ", fUD=" + this.fancyUnderwaterDetection + "]";
    }
}

