/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.loadable;

import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import org.bukkit.configuration.ConfigurationSection;

public class EntityConfiguration {
    private static final String ExplosionDamageBlocksUnderwater = "ExplosionDamageBlocksUnderwater";
    private static final String UnderwaterExplosionFactor = "UnderwaterExplosionFactor";
    private boolean explosionDamageBlocksUnderwater;
    private Double underwaterExplosionFactor;

    public static EntityConfiguration of(boolean explosionDamageBlocksUnderwater, Double underwaterExplosionFactor) {
        return new EntityConfiguration(explosionDamageBlocksUnderwater, underwaterExplosionFactor);
    }

    public static EntityConfiguration byDefault() {
        return EntityConfiguration.of(false, 0.5);
    }

    public static EntityConfiguration fromConfigurationSection(ConfigurationSection section) {
        EntityConfiguration defaults = EntityConfiguration.byDefault();
        return EntityConfiguration.of(section.getBoolean(ExplosionDamageBlocksUnderwater, defaults.isExplosionDamageBlocksUnderwater()), ConfigurationManager.ensureMin(section.getDouble(UnderwaterExplosionFactor, defaults.getUnderwaterExplosionFactor().doubleValue()), 0.0));
    }

    private EntityConfiguration(boolean explosionDamageBlocksUnderwater, Double underwaterExplosionFactor) {
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
        this.underwaterExplosionFactor = underwaterExplosionFactor;
    }

    public boolean isExplosionDamageBlocksUnderwater() {
        return this.explosionDamageBlocksUnderwater;
    }

    public void setExplosionDamageBlocksUnderwater(boolean explosionDamageBlocksUnderwater) {
        this.explosionDamageBlocksUnderwater = explosionDamageBlocksUnderwater;
    }

    public Double getUnderwaterExplosionFactor() {
        return this.underwaterExplosionFactor;
    }

    public void setUnderwaterExplosionFactor(Double underwaterExplosionFactor) {
        this.underwaterExplosionFactor = underwaterExplosionFactor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.explosionDamageBlocksUnderwater ? 1231 : 1237);
        result = 31 * result + (this.underwaterExplosionFactor == null ? 0 : this.underwaterExplosionFactor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityConfiguration other = (EntityConfiguration)obj;
        if (this.explosionDamageBlocksUnderwater != other.explosionDamageBlocksUnderwater) {
            return false;
        }
        return !(this.underwaterExplosionFactor == null ? other.underwaterExplosionFactor != null : !this.underwaterExplosionFactor.equals(other.underwaterExplosionFactor));
    }

    public String toString() {
        return "EntityConfiguration [eDBU=" + this.explosionDamageBlocksUnderwater + ", uEF=" + this.underwaterExplosionFactor + "]";
    }
}

