/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany;

import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.CannonProjectileConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.VanillaEntityConfiguration;
import io.github.guillex7.explodeany.listener.CommandExecutor;
import io.github.guillex7.explodeany.listener.ListenerManager;
import io.github.guillex7.explodeany.listener.loadable.BlockListener;
import io.github.guillex7.explodeany.listener.loadable.CannonExplosionListener;
import io.github.guillex7.explodeany.listener.loadable.EntityListener;
import io.github.guillex7.explodeany.listener.loadable.VanillaExplosionListener;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class ExplodeAny
extends JavaPlugin {
    private final String databaseFilename = "blockDatabase.json";

    public void onEnable() {
        super.onEnable();
        this.getLogger().log(Level.INFO, String.format("%s v%s is LOADING now!", this.getDescription().getName(), this.getDescription().getVersion()));
        this.loadConfiguration();
        this.loadDatabase();
        this.registerListeners();
    }

    public void onDisable() {
        super.onDisable();
        this.getLogger().log(Level.INFO, String.format("%s v%s is UNLOADING now!", this.getDescription().getName(), this.getDescription().getVersion()));
        this.unregisterListeners();
        this.unloadDatabase();
        this.unloadConfiguration();
    }

    public void loadConfiguration() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        configurationManager.loadConfiguration();
        configurationManager.registerEntityConfiguration(VanillaEntityConfiguration.empty());
        configurationManager.registerEntityConfiguration(CannonProjectileConfiguration.empty());
        configurationManager.loadAllEntityConfigurations();
    }

    public void loadDatabase() {
        if (ConfigurationManager.getInstance().doUseBlockDatabase()) {
            BlockDatabase blockDatabase = BlockDatabase.getInstance();
            blockDatabase.loadFromFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
            blockDatabase.sanitize();
            this.unloadDatabase();
        }
    }

    public void registerListeners() {
        ListenerManager listenerManager = ListenerManager.getInstance();
        listenerManager.registerListener(VanillaExplosionListener.empty());
        listenerManager.registerListener(CannonExplosionListener.empty());
        listenerManager.registerListener(BlockListener.empty());
        listenerManager.registerListener(EntityListener.empty());
        listenerManager.loadAllListeners();
        this.getCommand("explodeany").setExecutor((org.bukkit.command.CommandExecutor)new CommandExecutor());
    }

    public void unloadConfiguration() {
        ConfigurationManager.getInstance().unloadAllEntityConfigurations();
    }

    public void unloadDatabase() {
        if (ConfigurationManager.getInstance().doUseBlockDatabase()) {
            BlockDatabase.getInstance().saveToFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
        }
    }

    public void unregisterListeners() {
        ListenerManager.getInstance().unloadAllListeners();
    }

    public String getDatabaseFilename() {
        return "blockDatabase.json";
    }

    public static ExplodeAny getInstance() {
        return (ExplodeAny)JavaPlugin.getPlugin(ExplodeAny.class);
    }
}

