/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener.loadable.explosion.vanilla.entity;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.LoadableConfigurationSection;
import io.github.guillex7.explodeany.configuration.loadable.vanilla.entity.CustomVanillaEntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.data.ExplodingVanillaEntity;
import io.github.guillex7.explodeany.explosion.ExplosionManager;
import io.github.guillex7.explodeany.listener.loadable.explosion.vanilla.entity.BaseVanillaEntityExplosionListener;
import io.github.guillex7.explodeany.services.DebugManager;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityExplodeEvent;

public class UnknownVanillaEntityExplosionListener
extends BaseVanillaEntityExplosionListener {
    @Override
    public String getName() {
        return "Custom entities explosions";
    }

    @Override
    public boolean isAnnounceable() {
        return false;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.NORMAL)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.isEventHandled(event)) {
            return;
        }
        EntityType entityType = event.getEntityType();
        String entityTypeName = entityType.toString();
        if (DebugManager.getInstance().isDebugEnabled()) {
            ExplodeAny.getInstance().getLogger().log(Level.INFO, "Detected custom entity explosion. Entity type: {0}", entityTypeName);
        }
        Map<Material, EntityMaterialConfiguration> materialConfigurations = this.configuration.getEntityMaterialConfigurations().get(entityTypeName);
        EntityConfiguration entityConfiguration = this.configuration.getEntityConfigurations().get(entityTypeName);
        if (materialConfigurations == null || entityConfiguration == null) {
            return;
        }
        double explosionRadius = entityConfiguration.getExplosionRadius();
        if (explosionRadius == 0.0) {
            return;
        }
        if (ExplosionManager.getInstance().manageExplosion(materialConfigurations, entityConfiguration, event.getLocation(), explosionRadius)) {
            event.setCancelled(true);
        } else {
            ExplosionManager.getInstance().removeHandledBlocksFromList(materialConfigurations, event.blockList());
        }
    }

    @Override
    protected LoadableConfigurationSection<?> getConfiguration() {
        return ConfigurationManager.getInstance().getRegisteredLoadableConfigurationSection(CustomVanillaEntityConfiguration.getConfigurationId());
    }

    @Override
    protected boolean isEventHandled(EntityExplodeEvent event) {
        return super.isEventHandled(event) && !ExplodingVanillaEntity.isEntityNameValid(event.getEntityType().toString());
    }
}

