/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.listener.loadable.LoadableListener;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ListenerManager {
    private static ListenerManager instance;
    private final Map<String, LoadableListener> registeredListeners = new HashMap<String, LoadableListener>();

    private ListenerManager() {
    }

    public static ListenerManager getInstance() {
        if (instance == null) {
            instance = new ListenerManager();
        }
        return instance;
    }

    public Map<String, LoadableListener> getRegisteredListeners() {
        return this.registeredListeners;
    }

    public void registerListener(LoadableListener explosionListener) {
        this.getRegisteredListeners().put(explosionListener.getName(), explosionListener);
    }

    public void loadAllListeners() {
        for (LoadableListener listener : this.getRegisteredListeners().values()) {
            if (!listener.shouldBeLoaded()) continue;
            Bukkit.getServer().getPluginManager().registerEvents(listener.getEventListener(), (Plugin)ExplodeAny.getInstance());
            if (!listener.isAnnounceable()) continue;
            this.getPlugin().getLogger().info(String.format("Enabled support for %s", listener.getName()));
        }
    }

    public void unloadAllListeners() {
        for (LoadableListener explosionListener : this.getRegisteredListeners().values()) {
            if (!explosionListener.shouldBeLoaded()) continue;
            explosionListener.unload();
        }
    }

    public void unregisterAllListeners() {
        this.getRegisteredListeners().clear();
    }

    private ExplodeAny getPlugin() {
        return ExplodeAny.getInstance();
    }
}

