/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.explosion.drop;

import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.explosion.drop.DropCollector;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class PackedDropCollector
implements DropCollector {
    final Map<Material, Integer> collectedItems;

    public PackedDropCollector(Map<Material, EntityMaterialConfiguration> materialConfigurations) {
        this.collectedItems = new HashMap<Material, Integer>(materialConfigurations.size(), 1.0f);
    }

    @Override
    public void collect(Material material, Location location) {
        this.collectedItems.put(material, this.collectedItems.getOrDefault(material, 0) + 1);
    }

    @Override
    public void dropCollectedItems(Location location) {
        World world = location.getWorld();
        for (Map.Entry<Material, Integer> entry : this.collectedItems.entrySet()) {
            world.dropItemNaturally(location, new ItemStack(entry.getKey(), entry.getValue().intValue()));
        }
    }
}

