/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.explosion;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.block.BlockStatus;
import io.github.guillex7.explodeany.compat.common.api.IBlockDataUtils;
import io.github.guillex7.explodeany.compat.manager.CompatibilityManager;
import io.github.guillex7.explodeany.configuration.section.EntityBehavioralConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.explosion.drop.DropCollector;
import io.github.guillex7.explodeany.explosion.drop.PackedDropCollector;
import io.github.guillex7.explodeany.explosion.drop.UnpackedDropCollector;
import io.github.guillex7.explodeany.explosion.liquid.BlockLiquidDetector;
import io.github.guillex7.explodeany.explosion.liquid.TrajectoryExplosionLiquidDetector;
import io.github.guillex7.explodeany.explosion.metadata.ExplosionMetadata;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ExplosionManager {
    private static ExplosionManager instance;
    public static final String EXPLOSION_MANAGER_SPAWNED_TAG = "eany-em-spawned";
    public static final String EXPLOSION_MANAGER_EXPLOSION_METADATA_TAG = "eany-em-explosion-metadata";
    private final BlockLiquidDetector blockLiquidDetector = new BlockLiquidDetector();
    private final TrajectoryExplosionLiquidDetector trajectoryExplosionWaterDetector = new TrajectoryExplosionLiquidDetector();
    private final IBlockDataUtils blockDataUtils = CompatibilityManager.getInstance().getApi().getBlockDataUtils();
    private final BlockDatabase blockDatabase = BlockDatabase.getInstance();

    private ExplosionManager() {
    }

    public static ExplosionManager getInstance() {
        if (instance == null) {
            instance = new ExplosionManager();
        }
        return instance;
    }

    public void removeHandledBlocksFromList(Map<Material, EntityMaterialConfiguration> materialConfigurations, List<Block> blockList) {
        Iterator<Block> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!materialConfigurations.containsKey(block.getType())) continue;
            iterator.remove();
        }
    }

    private void attachExplosionManagerMetadataToEntity(Entity entity, Map<Material, EntityMaterialConfiguration> materialConfigurations, DropCollector dropCollector) {
        entity.setMetadata(EXPLOSION_MANAGER_SPAWNED_TAG, (MetadataValue)new FixedMetadataValue((Plugin)ExplodeAny.getInstance(), (Object)true));
        entity.setMetadata(EXPLOSION_MANAGER_EXPLOSION_METADATA_TAG, (MetadataValue)new FixedMetadataValue((Plugin)ExplodeAny.getInstance(), (Object)new ExplosionMetadata(materialConfigurations, dropCollector)));
    }

    public boolean isEntitySpawnedByExplosionManager(Entity entity) {
        return entity.hasMetadata(EXPLOSION_MANAGER_SPAWNED_TAG);
    }

    public ExplosionMetadata getExplosionManagerMetadataFromEntity(Entity entity) {
        List metadataValueList = entity.getMetadata(EXPLOSION_MANAGER_EXPLOSION_METADATA_TAG);
        if (!metadataValueList.isEmpty()) {
            return (ExplosionMetadata)((MetadataValue)metadataValueList.get(0)).value();
        }
        return new ExplosionMetadata(new HashMap<Material, EntityMaterialConfiguration>(), new UnpackedDropCollector());
    }

    public boolean manageExplosion(Map<Material, EntityMaterialConfiguration> materialConfigurations, EntityConfiguration entityConfiguration, Location sourceLocation, double originalRawExplosionRadius) {
        double rawExplosionRadius;
        boolean isSourceLocationLiquid = sourceLocation.getBlock().isLiquid();
        boolean isSourceLocationLiquidlike = this.blockLiquidDetector.isBlockLiquidlike(sourceLocation);
        double d = rawExplosionRadius = entityConfiguration.getExplosionRadius() != 0.0 ? entityConfiguration.getExplosionRadius() : originalRawExplosionRadius;
        rawExplosionRadius = isSourceLocationLiquidlike ? (rawExplosionRadius *= entityConfiguration.getUnderwaterExplosionFactor()) : (rawExplosionRadius *= entityConfiguration.getExplosionFactor());
        int explosionRadius = (int)rawExplosionRadius;
        int cx = sourceLocation.getBlockX();
        int cy = sourceLocation.getBlockY();
        int cz = sourceLocation.getBlockZ();
        int cxpr = cx + explosionRadius;
        int cypr = cy + explosionRadius;
        int czpr = cz + explosionRadius;
        int squaredExplosionRadius = explosionRadius * explosionRadius;
        World sourceWorld = sourceLocation.getWorld();
        Location sourceBlockLocation = new Location(sourceWorld, (double)cx, (double)cy, (double)cz);
        EntityBehavioralConfiguration entityBehavioralConfiguration = entityConfiguration.getEntityBehavioralConfiguration();
        Consumer<Block> waterloggedBlockConsumer = this.getWaterloggedBlockConsumer(entityBehavioralConfiguration, isSourceLocationLiquidlike);
        Consumer<Block> liquidBlockConsumer = this.getLiquidBlockConsumer(entityBehavioralConfiguration, isSourceLocationLiquidlike);
        DropCollector dropCollector = this.getDropCollector(entityConfiguration, materialConfigurations);
        if (!materialConfigurations.isEmpty() || entityBehavioralConfiguration.doesExplosionRemoveNearbyLiquids() || entityBehavioralConfiguration.doesExplosionRemoveWaterloggedStateFromNearbyBlocks() || entityBehavioralConfiguration.doesExplosionRemoveNearbyWaterloggedBlocks()) {
            for (int x = cx - explosionRadius; x < cxpr; ++x) {
                for (int y = cy - explosionRadius; y < cypr; ++y) {
                    for (int z = cz - explosionRadius; z < czpr; ++z) {
                        Block block;
                        int dx = x - cx;
                        int dy = y - cy;
                        int dz = z - cz;
                        int squaredDistance = dx * dx + dy * dy + dz * dz;
                        if (squaredExplosionRadius < squaredDistance || (block = sourceWorld.getBlockAt(x, y, z)).isEmpty()) continue;
                        EntityMaterialConfiguration materialConfiguration = materialConfigurations.get(block.getType());
                        if (materialConfiguration == null) {
                            if (this.blockDataUtils.isBlockWaterlogged(block)) {
                                waterloggedBlockConsumer.accept(block);
                                continue;
                            }
                            if (!block.isLiquid()) continue;
                            liquidBlockConsumer.accept(block);
                            continue;
                        }
                        this.damageBlock(materialConfiguration, block, sourceBlockLocation, explosionRadius, squaredExplosionRadius, squaredDistance, isSourceLocationLiquidlike, dropCollector);
                    }
                }
            }
        }
        entityConfiguration.getSoundConfiguration().playAt(sourceLocation);
        entityConfiguration.getParticleConfiguration().spawnAt(sourceLocation);
        if (entityConfiguration.doesExplosionDamageBlocksUnderwater() && isSourceLocationLiquidlike) {
            if (isSourceLocationLiquid) {
                sourceLocation.getBlock().setType(Material.AIR);
            } else {
                this.blockDataUtils.setIsBlockWaterlogged(sourceLocation.getBlock(), false);
            }
            this.spawnManagedExplosion(sourceLocation, materialConfigurations, rawExplosionRadius, dropCollector);
            return entityConfiguration.doReplaceOriginalExplosionWhenUnderwater();
        }
        if (entityConfiguration.doReplaceOriginalExplosion()) {
            this.spawnManagedExplosion(sourceLocation, materialConfigurations, rawExplosionRadius, dropCollector);
            return true;
        }
        dropCollector.dropCollectedItems(sourceBlockLocation);
        return false;
    }

    private void spawnManagedExplosion(Location location, Map<Material, EntityMaterialConfiguration> materialConfigurations, double explosionRadius, DropCollector dropCollector) {
        TNTPrimed explosiveEntity = (TNTPrimed)location.getWorld().spawn(location, TNTPrimed.class);
        this.attachExplosionManagerMetadataToEntity((Entity)explosiveEntity, materialConfigurations, dropCollector);
        explosiveEntity.setFuseTicks(0);
        explosiveEntity.setYield((float)explosionRadius);
    }

    private void damageBlock(EntityMaterialConfiguration materialConfiguration, Block targetBlock, Location sourceBlockLocation, int explosionRadius, double squaredExplosionRadius, double squaredDistance, boolean isSourceLocationLiquidlike, DropCollector dropCollector) {
        Location targetBlockLocation = targetBlock.getLocation();
        double effectiveDamage = materialConfiguration.getDamage();
        if (materialConfiguration.isUnderwaterAffected() && this.areUnderwaterRulesApplicable(materialConfiguration, sourceBlockLocation, targetBlockLocation, isSourceLocationLiquidlike, explosionRadius)) {
            effectiveDamage *= materialConfiguration.getUnderwaterDamageFactor();
        }
        BlockStatus affectedBlockStatus = this.blockDatabase.getBlockStatus(targetBlock);
        affectedBlockStatus.damage(effectiveDamage *= 1.0 - materialConfiguration.getDistanceAttenuationFactor() * (squaredDistance - 1.0) / squaredExplosionRadius);
        if (affectedBlockStatus.shouldBreak()) {
            materialConfiguration.getSoundConfiguration().playAt(targetBlockLocation);
            materialConfiguration.getParticleConfiguration().spawnAt(targetBlockLocation);
            Material targetBlockMaterial = targetBlock.getType();
            targetBlock.setType(Material.AIR);
            this.blockDatabase.removeBlockStatus(targetBlock);
            if (materialConfiguration.shouldBeDropped()) {
                dropCollector.collect(targetBlockMaterial, targetBlockLocation);
            }
        }
    }

    private boolean areUnderwaterRulesApplicable(EntityMaterialConfiguration materialConfiguration, Location sourceBlockLocation, Location targetBlockLocation, boolean isSourceLocationLiquidlike, int explosionRadius) {
        return materialConfiguration.isFancyUnderwaterDetection() ? this.trajectoryExplosionWaterDetector.isLiquidInTrajectory(sourceBlockLocation, targetBlockLocation, explosionRadius) : isSourceLocationLiquidlike;
    }

    private Consumer<Block> getWaterloggedBlockConsumer(EntityBehavioralConfiguration entityBehavioralConfiguration, boolean isSourceLocationLiquidlike) {
        boolean doesExplosionRemoveWaterloggedStateFromNearbyBlocks;
        boolean doesExplosionRemoveNearbyWaterloggedBlocksSurface = entityBehavioralConfiguration.doesExplosionRemoveNearbyWaterloggedBlocksSurface() && !isSourceLocationLiquidlike;
        boolean doesExplosionRemoveNearbyWaterloggedBlocksUnderwater = entityBehavioralConfiguration.doesExplosionRemoveNearbyWaterloggedBlocksUnderwater() && isSourceLocationLiquidlike;
        boolean doesExplosionRemoveNearbyWaterloggedBlocks = entityBehavioralConfiguration.doesExplosionRemoveNearbyWaterloggedBlocks() && (doesExplosionRemoveNearbyWaterloggedBlocksSurface || doesExplosionRemoveNearbyWaterloggedBlocksUnderwater);
        boolean doesExplosionRemoveWaterloggedStateFromNearbyBlocksSurface = entityBehavioralConfiguration.doesExplosionRemoveWaterloggedStateFromNearbyBlocksSurface() && !isSourceLocationLiquidlike;
        boolean doesExplosionRemoveWaterloggedStateFromNearbyBlocksUnderwater = entityBehavioralConfiguration.doesExplosionRemoveWaterloggedStateFromNearbyBlocksUnderwater() && isSourceLocationLiquidlike;
        boolean bl = doesExplosionRemoveWaterloggedStateFromNearbyBlocks = entityBehavioralConfiguration.doesExplosionRemoveWaterloggedStateFromNearbyBlocks() && (doesExplosionRemoveWaterloggedStateFromNearbyBlocksSurface || doesExplosionRemoveWaterloggedStateFromNearbyBlocksUnderwater);
        Consumer<Block> waterloggedBlockConsumer = doesExplosionRemoveNearbyWaterloggedBlocks ? block -> block.setType(Material.AIR) : (doesExplosionRemoveWaterloggedStateFromNearbyBlocks ? block -> this.blockDataUtils.setIsBlockWaterlogged((Block)block, false) : block -> {});
        return waterloggedBlockConsumer;
    }

    private Consumer<Block> getLiquidBlockConsumer(EntityBehavioralConfiguration entityBehavioralConfiguration, boolean isSourceLocationLiquidlike) {
        boolean doesExplosionRemoveNearbyLiquidsSurface = entityBehavioralConfiguration.doesExplosionRemoveNearbyLiquidsSurface() && !isSourceLocationLiquidlike;
        boolean doesExplosionRemoveNearbyLiquidsUnderwater = entityBehavioralConfiguration.doesExplosionRemoveNearbyLiquidsUnderwater() && isSourceLocationLiquidlike;
        boolean doesExplosionRemoveNearbyLiquids = entityBehavioralConfiguration.doesExplosionRemoveNearbyLiquids() && (doesExplosionRemoveNearbyLiquidsSurface || doesExplosionRemoveNearbyLiquidsUnderwater);
        Consumer<Block> liquidBlockConsumer = doesExplosionRemoveNearbyLiquids ? block -> block.setType(Material.AIR) : block -> {};
        return liquidBlockConsumer;
    }

    private DropCollector getDropCollector(EntityConfiguration entityConfiguration, Map<Material, EntityMaterialConfiguration> materialConfigurations) {
        return entityConfiguration.doPackDroppedItems() ? new PackedDropCollector(materialConfigurations) : new UnpackedDropCollector();
    }
}

