/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.data;

import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.WitherSkull;

public enum ExplodingVanillaEntity {
    WITHER("WITHER", 7.0),
    ENDER_CRYSTAL("ENDER_CRYSTAL", 6.0),
    PRIMED_TNT("PRIMED_TNT", 4.0),
    MINECART_TNT("MINECART_TNT", 4.0),
    CREEPER("CREEPER", 3.0),
    CHARGED_CREEPER("CHARGED_CREEPER", 5.0),
    FIREBALL("FIREBALL", 1.0),
    DRAGON_FIREBALL("DRAGON_FIREBALL", 1.0),
    SMALL_FIREBALL("SMALL_FIREBALL", 1.0),
    WITHER_SKULL("WITHER_SKULL", 1.0),
    CHARGED_WITHER_SKULL("CHARGED_WITHER_SKULL", 1.0),
    BED("BED", 5.0),
    RESPAWN_ANCHOR("RESPAWN_ANCHOR", 5.0);

    private final String name;
    private final double explosionRadius;

    public static boolean isEntityNameValid(String entityName) {
        return ExplodingVanillaEntity.fromEntityTypeName(entityName) != null;
    }

    public static ExplodingVanillaEntity fromEntityTypeName(String entityTypeName) {
        String uppercasedEntityTypeName = entityTypeName.toUpperCase();
        if ("TNT".equals(uppercasedEntityTypeName)) {
            return PRIMED_TNT;
        }
        if ("TNT_MINECART".equals(uppercasedEntityTypeName)) {
            return MINECART_TNT;
        }
        if ("END_CRYSTAL".equals(uppercasedEntityTypeName)) {
            return ENDER_CRYSTAL;
        }
        try {
            return ExplodingVanillaEntity.valueOf(uppercasedEntityTypeName);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    public static ExplodingVanillaEntity fromEntity(Entity entity) {
        String entityTypeName = entity.getType().toString();
        EntityType entityType = entity.getType();
        if (entityType.equals((Object)EntityType.CREEPER) && ((Creeper)entity).isPowered() || entityType.equals((Object)EntityType.WITHER_SKULL) && ((WitherSkull)entity).isCharged()) {
            entityTypeName = "CHARGED_".concat(entityTypeName);
        }
        return ExplodingVanillaEntity.fromEntityTypeName(entityTypeName);
    }

    private ExplodingVanillaEntity(String name, double explosionRadius) {
        this.name = name;
        this.explosionRadius = explosionRadius;
    }

    public String getName() {
        return this.name;
    }

    public double getExplosionRadius() {
        return this.explosionRadius;
    }
}

