/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;

public class SoundConfiguration {
    public static final String ROOT_PATH = "Sound";
    private static final String NAME_PATH = "Name";
    private static final String VOLUME_PATH = "Volume";
    private static final String PITCH_PATH = "Pitch";
    private Sound sound;
    private double volume;
    private double pitch;

    public static SoundConfiguration byDefault() {
        return new SoundConfiguration(null, 1.0, 1.0);
    }

    public static SoundConfiguration fromConfigurationSection(ConfigurationSection section) {
        Sound sound;
        SoundConfiguration defaults = SoundConfiguration.byDefault();
        try {
            sound = Sound.valueOf((String)section.getString(NAME_PATH, "").toUpperCase());
        }
        catch (Exception e) {
            sound = null;
        }
        return new SoundConfiguration(sound, MathUtils.ensureMin(section.getDouble(VOLUME_PATH, defaults.getVolume()), 0.0), MathUtils.ensureRange(section.getDouble(PITCH_PATH, defaults.getPitch()), 2.0, 0.5));
    }

    public SoundConfiguration(Sound sound, double volume, double pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void playAt(Location location) {
        location.getWorld().playSound(location, this.sound, (float)this.volume, (float)this.pitch);
    }

    public boolean isValid() {
        return this.sound != null;
    }

    public Sound getSound() {
        return this.sound;
    }

    public double getVolume() {
        return this.volume;
    }

    public double getPitch() {
        return this.pitch;
    }

    public String toString() {
        return this.isValid() ? String.format("Sound name: %s\nVolume: %.2f\nPitch: %.2f", this.getSound().name(), this.getVolume(), this.getPitch()) : "(None)";
    }
}

