/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.section.ParticleConfiguration;
import io.github.guillex7.explodeany.configuration.section.SoundConfiguration;
import io.github.guillex7.explodeany.util.MathUtils;
import org.bukkit.configuration.ConfigurationSection;

public class EntityMaterialConfiguration {
    private static final String DAMAGE_PATH = "Damage";
    private static final String DROP_CHANCE_PATH = "DropChance";
    private static final String DISTANCE_ATTENUATION_FACTOR_PATH = "DistanceAttenuationFactor";
    private static final String UNDERWATER_DAMAGE_FACTOR_PATH = "UnderwaterDamageFactor";
    private static final String FANCY_UNDERWATER_DETECTION_PATH = "FancyUnderwaterDetection";
    private double damage;
    private double dropChance;
    private double distanceAttenuationFactor;
    private double underwaterDamageFactor;
    private boolean fancyUnderwaterDetection;
    private SoundConfiguration soundConfiguration;
    private ParticleConfiguration particleConfiguration;

    public static EntityMaterialConfiguration byDefault() {
        return new EntityMaterialConfiguration(ConfigurationManager.getInstance().getBlockDurability(), 0.0, 0.0, 0.5, false, SoundConfiguration.byDefault(), ParticleConfiguration.byDefault());
    }

    public static EntityMaterialConfiguration fromConfigurationSection(ConfigurationSection section) {
        EntityMaterialConfiguration defaults = EntityMaterialConfiguration.byDefault();
        ConfigurationSection soundConfigurationSection = section.getConfigurationSection("Sound");
        ConfigurationSection particleConfigurationSection = section.getConfigurationSection("Particles");
        return new EntityMaterialConfiguration(MathUtils.ensureMin(section.getDouble(DAMAGE_PATH, defaults.getDamage()), 0.0), MathUtils.ensureRange(section.getDouble(DROP_CHANCE_PATH, defaults.getDropChance()), 100.0, 0.0) / 100.0, MathUtils.ensureRange(section.getDouble(DISTANCE_ATTENUATION_FACTOR_PATH, defaults.getDistanceAttenuationFactor()), 1.0, 0.0), MathUtils.ensureMin(section.getDouble(UNDERWATER_DAMAGE_FACTOR_PATH, defaults.getUnderwaterDamageFactor()), 0.0), section.getBoolean(FANCY_UNDERWATER_DETECTION_PATH, defaults.isFancyUnderwaterDetection()), soundConfigurationSection != null ? SoundConfiguration.fromConfigurationSection(soundConfigurationSection) : SoundConfiguration.byDefault(), particleConfigurationSection != null ? ParticleConfiguration.fromConfigurationSection(particleConfigurationSection) : ParticleConfiguration.byDefault());
    }

    public EntityMaterialConfiguration(double damage, double dropChance, double distanceAttenuationFactor, double underwaterDamageFactor, boolean fancyUnderwaterDetection, SoundConfiguration soundConfiguration, ParticleConfiguration particleConfiguration) {
        this.damage = damage;
        this.dropChance = dropChance;
        this.distanceAttenuationFactor = distanceAttenuationFactor;
        this.underwaterDamageFactor = underwaterDamageFactor;
        this.fancyUnderwaterDetection = fancyUnderwaterDetection;
        this.soundConfiguration = soundConfiguration;
        this.particleConfiguration = particleConfiguration;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public int getDropChancePercentage() {
        return (int)(this.getDropChance() * 100.0);
    }

    public boolean shouldBeDropped() {
        return Math.random() < this.getDropChance();
    }

    public double getDistanceAttenuationFactor() {
        return this.distanceAttenuationFactor;
    }

    public double getUnderwaterDamageFactor() {
        return this.underwaterDamageFactor;
    }

    public boolean isUnderwaterAffected() {
        return this.getUnderwaterDamageFactor() != 1.0;
    }

    public boolean isFancyUnderwaterDetection() {
        return this.fancyUnderwaterDetection;
    }

    public SoundConfiguration getSoundConfiguration() {
        return this.soundConfiguration;
    }

    public ParticleConfiguration getParticleConfiguration() {
        return this.particleConfiguration;
    }

    public String toString() {
        return String.format("&7<General>\n&fDamage: %.2f\n&fDrop chance: %d%%\n&fDistance attenuation factor: x%.2f\n&fUnderwater damage factor: x%.2f\n&fFancy underwater detection: %b\n\n&7<Sound>\n&f%s\n\n&7<Particle>\n&f%s", this.getDamage(), this.getDropChancePercentage(), this.getDistanceAttenuationFactor(), this.getUnderwaterDamageFactor(), this.isFancyUnderwaterDetection(), this.getSoundConfiguration().toString(), this.getParticleConfiguration().toString());
    }
}

