/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.compat.v1_8_3.api;

import io.github.guillex7.explodeany.compat.common.event.EanyBlockExplodeEvent;
import io.github.guillex7.explodeany.compat.common.event.IBukkitListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;

public class CBlockExplodeListener
implements IBukkitListener {
    protected final Consumer<EanyBlockExplodeEvent> eanyBlockExplodeEventConsumer;
    protected Map<Location, String> identifiedExplosiveBlocks;

    public CBlockExplodeListener(Consumer<EanyBlockExplodeEvent> eanyBlockExplodeEventConsumer) {
        this.eanyBlockExplodeEventConsumer = eanyBlockExplodeEventConsumer;
        this.identifiedExplosiveBlocks = new HashMap<Location, String>();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=false)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (!event.getBed().getWorld().getEnvironment().equals((Object)World.Environment.NORMAL)) {
            Location bedLocation = event.getBed().getLocation();
            this.identifiedExplosiveBlocks.put(bedLocation, "BED");
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=false)
    public void onBlockExplode(final BlockExplodeEvent event) {
        final Location blockLocation = event.getBlock().getLocation();
        if (this.identifiedExplosiveBlocks.containsKey(blockLocation)) {
            final String explodingVanillaMaterial = this.identifiedExplosiveBlocks.get(blockLocation);
            this.identifiedExplosiveBlocks.remove(blockLocation);
            this.eanyBlockExplodeEventConsumer.accept(new EanyBlockExplodeEvent(){

                @Override
                public Location getBlockLocation() {
                    return blockLocation;
                }

                @Override
                public String getBlockMaterial() {
                    return explodingVanillaMaterial;
                }

                @Override
                public List<Block> getBlockList() {
                    return event.blockList();
                }

                @Override
                public boolean isCancelled() {
                    return event.isCancelled();
                }

                @Override
                public void setCancelled(boolean cancelled) {
                    event.setCancelled(cancelled);
                }
            });
        }
    }

    @Override
    public boolean shouldBeLoaded() {
        return true;
    }

    @Override
    public void unload() {
        BlockExplodeEvent.getHandlerList().unregister((Listener)this);
    }
}

