/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.block;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;

public class BlockLocation {
    private UUID worldUuid;
    private int x;
    private int y;
    private int z;

    public static BlockLocation fromBlock(Block block) {
        return new BlockLocation(block.getWorld().getUID(), block.getX(), block.getY(), block.getZ());
    }

    public BlockLocation(UUID worldUuid, int x, int y, int z) {
        this.worldUuid = worldUuid;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public World getWorld() {
        return Bukkit.getServer().getWorld(this.worldUuid);
    }

    public Block toBlock() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return world.getBlockAt(this.x, this.y, this.z);
    }

    public UUID getWorldUuid() {
        return this.worldUuid;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.worldUuid == null ? 0 : this.worldUuid.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockLocation other = (BlockLocation)obj;
        if (this.worldUuid == null ? other.worldUuid != null : !this.worldUuid.equals(other.worldUuid)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

