/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class MaterialGroups {
    private static final String materialColorsKeyword = "ANYCOLOR";
    private static final String woodTypesKeyword = "ANYWOODTYPE";
    private static final Set<String> materialColors = MaterialGroups.createStaticHashSet("WHITE", "ORANGE", "MAGENTA", "LIGHT_BLUE", "YELLOW", "LIME", "PINK", "GRAY", "LIGHT_GRAY", "CYAN", "PURPLE", "BLUE", "BROWN", "GREEN", "RED", "BLACK");
    private static final Set<String> woodTypes = MaterialGroups.createStaticHashSet("OAK", "SPRUCE", "BIRCH", "JUNGLE", "ACACIA", "DARK_OAK");

    @SafeVarargs
    public static final <T> Set<T> createStaticHashSet(T ... objs) {
        HashSet set = new HashSet();
        Collections.addAll(set, objs);
        return set;
    }

    private static final Set<String> getMaterialColors() {
        return materialColors;
    }

    private static final Set<String> getWoodTypes() {
        return woodTypes;
    }

    public static final String getMaterialColorsKeyword() {
        return materialColorsKeyword;
    }

    public static final String getWoodTypesKeyword() {
        return woodTypesKeyword;
    }

    public static Set<Material> expandKeywordsToMaterials(String materialName) {
        HashSet<Material> allMaterials = new HashSet<Material>();
        allMaterials.addAll(MaterialGroups.expandColors(materialName));
        allMaterials.addAll(MaterialGroups.expandWoodTypes(materialName));
        return allMaterials;
    }

    private static Set<Material> expandColors(String materialName) {
        HashSet<Material> coloredMaterials = new HashSet<Material>();
        if (materialName.contains(MaterialGroups.getMaterialColorsKeyword())) {
            for (String materialColor : MaterialGroups.getMaterialColors()) {
                Material coloredMaterial;
                try {
                    coloredMaterial = Material.valueOf((String)materialName.replaceAll(MaterialGroups.getMaterialColorsKeyword(), materialColor));
                }
                catch (Exception e) {
                    continue;
                }
                coloredMaterials.add(coloredMaterial);
            }
        }
        return coloredMaterials;
    }

    private static Set<Material> expandWoodTypes(String materialName) {
        HashSet<Material> woodTypedMaterials = new HashSet<Material>();
        if (materialName.contains(MaterialGroups.getWoodTypesKeyword())) {
            for (String woodType : MaterialGroups.getWoodTypes()) {
                Material woodTypedMaterial;
                try {
                    woodTypedMaterial = Material.valueOf((String)materialName.replaceAll(MaterialGroups.getWoodTypesKeyword(), woodType));
                }
                catch (Exception e) {
                    continue;
                }
                woodTypedMaterials.add(woodTypedMaterial);
            }
        }
        return woodTypedMaterials;
    }
}

