/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener.loadable;

import io.github.guillex7.explodeany.configuration.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.VanillaEntityConfiguration;
import io.github.guillex7.explodeany.explosion.ExplosionManager;
import io.github.guillex7.explodeany.listener.loadable.LoadableExplosionListener;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public final class VanillaExplosionListener
implements LoadableExplosionListener {
    private static VanillaExplosionListener instance;

    private VanillaExplosionListener() {
    }

    public static VanillaExplosionListener getInstance() {
        if (instance == null) {
            instance = new VanillaExplosionListener();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "Vanilla";
    }

    @Override
    public boolean shouldBeLoaded() {
        return VanillaEntityConfiguration.getInstance().shouldBeLoaded();
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent event) {
        WitherSkull witherSkull;
        if (event.getEntity() == null) {
            return;
        }
        String entityTypeName = event.getEntityType().toString();
        boolean isCharged = false;
        Map<Material, EntityMaterialConfiguration> materialConfigurations = null;
        if (event.getEntityType().equals((Object)EntityType.CREEPER)) {
            Creeper creeper = (Creeper)event.getEntity();
            if (creeper.isPowered()) {
                entityTypeName = "CHARGED_".concat(entityTypeName);
                isCharged = true;
            }
        } else if (event.getEntityType().equals((Object)EntityType.WITHER_SKULL) && (witherSkull = (WitherSkull)event.getEntity()).isCharged()) {
            entityTypeName = "CHARGED_".concat(entityTypeName);
            isCharged = true;
        }
        materialConfigurations = VanillaEntityConfiguration.getInstance().getEntityMaterialConfigurations().get(entityTypeName);
        if (materialConfigurations == null) {
            return;
        }
        int explosionRadius = 0;
        switch (event.getEntityType()) {
            case WITHER: {
                explosionRadius = 7;
                break;
            }
            case ENDER_CRYSTAL: {
                explosionRadius = 6;
                break;
            }
            case PRIMED_TNT: {
                explosionRadius = 4;
                break;
            }
            case CREEPER: {
                explosionRadius = isCharged ? 4 : 3;
                break;
            }
            case FIREBALL: 
            case DRAGON_FIREBALL: 
            case SMALL_FIREBALL: 
            case WITHER_SKULL: {
                explosionRadius = 1;
                break;
            }
        }
        if (explosionRadius <= 0) {
            return;
        }
        ExplosionManager.removeHandledBlocksFromList(materialConfigurations, event.blockList());
        ExplosionManager.manageExplosion(materialConfigurations, event.getLocation(), explosionRadius);
    }

    @Override
    public void unload() {
        EntityExplodeEvent.getHandlerList().unregister((Listener)this);
    }
}

