/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration;

import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import org.bukkit.configuration.ConfigurationSection;

public class EntityMaterialConfiguration {
    private static final String DAMAGE_PATH = "Damage";
    private static final String UNDERWATER_DAMAGE_FACTOR_PATH = "UnderwaterDamageFactor";
    private static final String DROP_CHANCE_PATH = "DropChance";
    private static final String DISTANCE_ATTENUATION_FACTOR_PATH = "DistanceAttenuationFactor";
    private static final String EXPLOSION_RADIUS_FACTOR_PATH = "ExplosionRadiusFactor";
    private double damage;
    private double underwaterDamageFactor;
    private double dropChance;
    private double distanceAttenuationFactor;
    private double explosionRadiusFactor;

    public static EntityMaterialConfiguration of(double damage, double underwaterDamageFactor, double dropChance, double distanceAttenuationFactor, double explosionRadiusFactor) {
        return new EntityMaterialConfiguration(damage, underwaterDamageFactor, dropChance, distanceAttenuationFactor, explosionRadiusFactor);
    }

    public static EntityMaterialConfiguration fromConfigurationSection(ConfigurationSection section) {
        return EntityMaterialConfiguration.of(ConfigurationManager.ensureMin(section.getDouble(DAMAGE_PATH, 0.0), 0.0), ConfigurationManager.ensureMin(section.getDouble(UNDERWATER_DAMAGE_FACTOR_PATH, 1.0), 0.0), ConfigurationManager.ensureRange(section.getDouble(DROP_CHANCE_PATH, 0.0), 100.0, 0.0) / 100.0, ConfigurationManager.ensureRange(section.getDouble(DISTANCE_ATTENUATION_FACTOR_PATH, 0.0), 1.0, 0.0), ConfigurationManager.ensureRange(section.getDouble(EXPLOSION_RADIUS_FACTOR_PATH, 0.5), 1.0, 0.0));
    }

    private EntityMaterialConfiguration(double damage, double underwaterDamageFactor, double dropChance, double distanceAttenuationFactor, double explosionRadiusFactor) {
        this.damage = damage;
        this.underwaterDamageFactor = underwaterDamageFactor;
        this.dropChance = dropChance;
        this.distanceAttenuationFactor = distanceAttenuationFactor;
        this.explosionRadiusFactor = explosionRadiusFactor;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getUnderwaterDamageFactor() {
        return this.underwaterDamageFactor;
    }

    public boolean isUnderwaterAffected() {
        return this.getUnderwaterDamageFactor() != 1.0;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public boolean shouldBeDropped() {
        return Math.random() <= this.getDropChance();
    }

    public double getDistanceAttenuationFactor() {
        return this.distanceAttenuationFactor;
    }

    public double getExplosionRadiusFactor() {
        return this.explosionRadiusFactor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.damage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.distanceAttenuationFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.explosionRadiusFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.dropChance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.underwaterDamageFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityMaterialConfiguration other = (EntityMaterialConfiguration)obj;
        if (Double.doubleToLongBits(this.damage) != Double.doubleToLongBits(other.damage)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distanceAttenuationFactor) != Double.doubleToLongBits(other.distanceAttenuationFactor)) {
            return false;
        }
        if (Double.doubleToLongBits(this.explosionRadiusFactor) != Double.doubleToLongBits(other.explosionRadiusFactor)) {
            return false;
        }
        if (Double.doubleToLongBits(this.dropChance) != Double.doubleToLongBits(other.dropChance)) {
            return false;
        }
        return Double.doubleToLongBits(this.underwaterDamageFactor) == Double.doubleToLongBits(other.underwaterDamageFactor);
    }

    public String toString() {
        return "EntityMaterialConfiguration [d=" + this.damage + ", uDF=" + this.underwaterDamageFactor + ", dC=" + this.dropChance + ", dAF=" + this.distanceAttenuationFactor + ", eRF=" + this.explosionRadiusFactor + "]";
    }
}

