/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.listener;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.listener.loadable.LoadableExplosionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ExplosionListenerManager {
    private static ExplosionListenerManager instance;
    private List<LoadableExplosionListener> explosionListeners = new ArrayList<LoadableExplosionListener>();

    private ExplosionListenerManager() {
    }

    public static ExplosionListenerManager getInstance() {
        if (instance == null) {
            instance = new ExplosionListenerManager();
        }
        return instance;
    }

    public List<LoadableExplosionListener> getRegisteredExplosionListeners() {
        return this.explosionListeners;
    }

    public void registerExplosionListener(LoadableExplosionListener explosionListener) {
        this.getRegisteredExplosionListeners().add(explosionListener);
    }

    public void unloadAllExplosionListeners() {
        for (LoadableExplosionListener explosionListener : this.getRegisteredExplosionListeners()) {
            if (!explosionListener.shouldBeLoaded()) continue;
            explosionListener.unload();
        }
        this.getRegisteredExplosionListeners().clear();
    }

    public void loadAllExplosionListeners() {
        for (LoadableExplosionListener explosionListener : this.getRegisteredExplosionListeners()) {
            if (!explosionListener.shouldBeLoaded()) continue;
            Bukkit.getServer().getPluginManager().registerEvents((Listener)explosionListener, (Plugin)ExplodeAny.getInstance());
            this.getLogger().log(Level.INFO, String.format("Enabled support for %s", explosionListener.getName()));
        }
    }

    private Logger getLogger() {
        return ExplodeAny.getInstance().getLogger();
    }
}

