/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.explosion;

import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.block.BlockStatus;
import io.github.guillex7.explodeany.configuration.EntityMaterialConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class ExplosionManager {
    public static void removeHandledBlocksFromList(Map<Material, EntityMaterialConfiguration> materialConfigurations, List<Block> blockList) {
        Iterator<Block> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!materialConfigurations.containsKey(block.getType())) continue;
            iterator.remove();
        }
    }

    public static void manageExplosion(Map<Material, EntityMaterialConfiguration> materialConfigurations, Location sourceLocation, int explosionRadius) {
        int cx = sourceLocation.getBlockX();
        int cy = sourceLocation.getBlockY();
        int cz = sourceLocation.getBlockZ();
        Vector sourceVector = new Vector(cx, cy, cz);
        int cxpr = cx + explosionRadius;
        int cypr = cy + explosionRadius;
        int czpr = cz + explosionRadius;
        int squaredExplosionRadius = explosionRadius * explosionRadius;
        int x = cx - explosionRadius;
        while (x < cxpr) {
            int y = cy - explosionRadius;
            while (y < cypr) {
                int z = cz - explosionRadius;
                while (z < czpr) {
                    double squaredDistance = sourceVector.distanceSquared(new Vector(x, y, z));
                    if ((double)squaredExplosionRadius >= squaredDistance) {
                        Block block = sourceLocation.getWorld().getBlockAt(x, y, z);
                        ExplosionManager.tryDamageBlock(materialConfigurations, block, sourceLocation, squaredExplosionRadius, squaredDistance);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void tryDamageBlock(Map<Material, EntityMaterialConfiguration> materialConfigurations, Block targetBlock, Location sourceLocation, int squaredExplosionRadius, double squaredDistance) {
        double maximumSquaredDistance;
        EntityMaterialConfiguration materialConfiguration = materialConfigurations.get(targetBlock.getType());
        if (materialConfiguration == null) {
            return;
        }
        double effectiveDamage = materialConfiguration.getDamage();
        if (materialConfiguration.isUnderwaterAffected() && ExplosionManager.isLiquidInLocation(sourceLocation)) {
            effectiveDamage *= materialConfiguration.getUnderwaterDamageFactor();
        }
        if (squaredDistance > (maximumSquaredDistance = (double)squaredExplosionRadius * materialConfiguration.getExplosionRadiusFactor())) {
            return;
        }
        BlockStatus affectedBlockStatus = BlockDatabase.getInstance().getBlockStatus(targetBlock);
        affectedBlockStatus.damage(effectiveDamage *= 1.0 - materialConfiguration.getDistanceAttenuationFactor() * (squaredDistance - 1.0) / maximumSquaredDistance);
        if (affectedBlockStatus.shouldBreak()) {
            if (materialConfiguration.shouldBeDropped()) {
                targetBlock.breakNaturally();
            } else {
                targetBlock.setType(Material.AIR);
            }
            BlockDatabase.getInstance().removeBlockStatus(targetBlock);
        }
    }

    public static boolean isLiquidInLocation(Location location) {
        return location.getBlock().isLiquid();
    }
}

