/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.configuration.ConfigurationLocale;
import io.github.guillex7.explodeany.configuration.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.LoadableSectionConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;

public final class ConfigurationManager {
    private static ConfigurationManager instance;
    private List<LoadableSectionConfiguration<?>> entityConfigurations = new ArrayList();
    private Set<Material> handledMaterials = new HashSet<Material>();

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    public static double ensureRange(double value, double max, double min) {
        return Math.min(Math.max(value, min), max);
    }

    public static double ensureMax(double value, double max) {
        return Math.min(value, max);
    }

    public static double ensureMin(double value, double min) {
        return Math.max(value, min);
    }

    public boolean doUseBlockDatabase() {
        return ExplodeAny.getInstance().getConfig().getBoolean("UseBlockDatabase", false);
    }

    public boolean doCheckBlockDatabaseAtStartup() {
        return ExplodeAny.getInstance().getConfig().getBoolean("CheckBlockDatabaseAtStartup", false);
    }

    public Double getBlockDurability() {
        return ExplodeAny.getInstance().getConfig().getDouble("BlockDurability", 100.0);
    }

    public String getLocale(ConfigurationLocale locale) {
        return ExplodeAny.getInstance().getConfig().getString(String.format("%s.%s", "Locale", locale.getPath()), locale.getDefaultLocale());
    }

    public List<LoadableSectionConfiguration<?>> getRegisteredEntityConfigurations() {
        return this.entityConfigurations;
    }

    public void registerEntityConfiguration(LoadableSectionConfiguration<?> entityConfiguration) {
        this.getRegisteredEntityConfigurations().add(entityConfiguration);
    }

    public void unloadAllEntityConfigurations() {
        this.getRegisteredEntityConfigurations().clear();
        this.getHandledMaterials().clear();
    }

    public void loadAllEntityConfigurations() {
        FileConfiguration config = ExplodeAny.getInstance().getConfig();
        for (LoadableSectionConfiguration<?> entityConfiguration : this.getRegisteredEntityConfigurations()) {
            if (!entityConfiguration.shouldBeLoaded()) continue;
            entityConfiguration.clearEntityMaterialConfigurations();
            entityConfiguration.fetchEntityMaterialConfigurations(config);
            for (Map<Material, EntityMaterialConfiguration> map : entityConfiguration.getEntityMaterialConfigurations().values()) {
                this.getHandledMaterials().addAll(map.keySet());
            }
        }
    }

    public Set<Material> getHandledMaterials() {
        return this.handledMaterials;
    }

    public boolean handlesBlock(Block block) {
        return this.getHandledMaterials().contains(block.getType());
    }

    private class ConfigurationKeys {
        public static final String USE_BLOCK_DATABASE = "UseBlockDatabase";
        public static final String CHECK_BLOCK_DATABASE_AT_STARTUP = "CheckBlockDatabaseAtStartup";
        public static final String BLOCK_DURABILITY_ITEM = "BlockDurability";
        public static final String LOCALE_SECTION = "Locale";

        private ConfigurationKeys() {
        }
    }
}

