/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.block;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class BlockLocation {
    private UUID worldUUID;
    private int x;
    private int y;
    private int z;

    public static BlockLocation of(UUID worldUUID, int x, int y, int z) {
        return new BlockLocation(worldUUID, x, y, z);
    }

    public static BlockLocation fromLocation(Location location) {
        return BlockLocation.of(location.getWorld().getUID(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static BlockLocation fromBlock(Block block) {
        return BlockLocation.of(block.getWorld().getUID(), block.getX(), block.getY(), block.getZ());
    }

    private BlockLocation(UUID worldUUID, int x, int y, int z) {
        this.worldUUID = worldUUID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public World getWorld() {
        return Bukkit.getServer().getWorld(this.worldUUID);
    }

    public Location toLocation() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return new Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    public Block toBlock() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return world.getBlockAt(this.x, this.y, this.z);
    }

    public UUID getWorldUUID() {
        return this.worldUUID;
    }

    public void setWorldUUID(UUID worldUUID) {
        this.worldUUID = worldUUID;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.worldUUID == null ? 0 : this.worldUUID.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockLocation other = (BlockLocation)obj;
        if (this.worldUUID == null ? other.worldUUID != null : !this.worldUUID.equals(other.worldUUID)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "BlockLocation [worldUUID=" + this.worldUUID + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

