/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.block;

import io.github.guillex7.explodeany.ExplodeAny;
import io.github.guillex7.explodeany.block.BlockLocation;
import io.github.guillex7.explodeany.block.BlockLocationAdapter;
import io.github.guillex7.explodeany.block.BlockStatus;
import io.github.guillex7.explodeany.block.BlockStatusAdapter;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.gson.Gson;
import io.github.guillex7.gson.GsonBuilder;
import io.github.guillex7.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.block.Block;

public class BlockDatabase {
    private static BlockDatabase instance;
    private Map<BlockLocation, BlockStatus> database = new HashMap<BlockLocation, BlockStatus>();
    private static final TypeToken<Map<BlockLocation, BlockStatus>> databaseTypeToken;

    static {
        databaseTypeToken = new TypeToken<Map<BlockLocation, BlockStatus>>(){};
    }

    private BlockDatabase() {
    }

    public static BlockDatabase getInstance() {
        if (instance == null) {
            instance = new BlockDatabase();
        }
        return instance;
    }

    public BlockStatus getBlockStatus(Block block) {
        BlockLocation blockLocation = BlockLocation.fromBlock(block);
        BlockStatus blockStatus = this.getDatabase().get(blockLocation);
        if (blockStatus == null || !blockStatus.isCongruentWith(block)) {
            blockStatus = BlockStatus.defaultForBlock(block);
            this.getDatabase().put(blockLocation, blockStatus);
        }
        return blockStatus;
    }

    public void removeBlockStatus(Block block) {
        this.getDatabase().remove(BlockLocation.fromBlock(block));
    }

    public void loadFromFile(File databaseFile) {
        if (!databaseFile.exists() || !databaseFile.canRead()) {
            BlockDatabase.getLogger().log(Level.INFO, "Database doesn't exist yet, will create a new database");
            return;
        }
        this.setDatabase(this.deserializeDatabaseFile(databaseFile));
    }

    public void saveToFile(File databaseFile) {
        if (!databaseFile.exists()) {
            try {
                databaseFile.createNewFile();
            }
            catch (IOException e) {
                BlockDatabase.getLogger().log(Level.WARNING, "Couldn't create a new database file! Database won't be saved");
                return;
            }
        }
        this.serializeDatabaseFile(databaseFile, this.database);
    }

    public void sanitize() {
        Iterator<Map.Entry<BlockLocation, BlockStatus>> iterator = this.getDatabase().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockLocation, BlockStatus> entry = iterator.next();
            if (this.sanitizeEntry(entry)) {
                iterator.remove();
                continue;
            }
            if (!ConfigurationManager.getInstance().doCheckBlockDatabaseAtStartup() || !this.deepSanitizeEntry(entry)) continue;
            iterator.remove();
        }
    }

    private boolean sanitizeEntry(Map.Entry<BlockLocation, BlockStatus> entry) {
        BlockStatus blockStatus = entry.getValue();
        if (blockStatus.shouldBreak()) {
            return true;
        }
        blockStatus.sanitize();
        return false;
    }

    private boolean deepSanitizeEntry(Map.Entry<BlockLocation, BlockStatus> entry) {
        Block block = entry.getKey().toBlock();
        BlockStatus blockStatus = entry.getValue();
        return block.isEmpty() || !ConfigurationManager.getInstance().handlesBlock(block) || !blockStatus.isCongruentWith(block);
    }

    private static Logger getLogger() {
        return ExplodeAny.getInstance().getLogger();
    }

    private Map<BlockLocation, BlockStatus> getDatabase() {
        return this.database;
    }

    private void setDatabase(Map<BlockLocation, BlockStatus> database) {
        this.database = database;
    }

    private static TypeToken<Map<BlockLocation, BlockStatus>> getDatabaseTypeToken() {
        return databaseTypeToken;
    }

    private Map<BlockLocation, BlockStatus> deserializeDatabaseFile(File databaseFile) {
        Map<BlockLocation, BlockStatus> loadedDatabase = new HashMap<BlockLocation, BlockStatus>();
        try {
            FileReader fr = new FileReader(databaseFile);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockLocation.class), new BlockLocationAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockStatus.class), new BlockStatusAdapter());
            gsonBuilder.enableComplexMapKeySerialization();
            Gson gson = gsonBuilder.create();
            loadedDatabase = (Map)gson.fromJson((Reader)fr, BlockDatabase.getDatabaseTypeToken().getType());
            fr.close();
            BlockDatabase.getLogger().log(Level.INFO, "Database loaded successfully");
        }
        catch (Exception e) {
            BlockDatabase.getLogger().log(Level.WARNING, "Couldn't load database, creating an empty one");
        }
        return loadedDatabase;
    }

    private void serializeDatabaseFile(File databaseFile, Map<BlockLocation, BlockStatus> database) {
        try {
            FileWriter fw = new FileWriter(databaseFile);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockLocation.class), new BlockLocationAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)BlockStatus.class), new BlockStatusAdapter());
            gsonBuilder.enableComplexMapKeySerialization();
            Gson gson = gsonBuilder.create();
            gson.toJson(database, BlockDatabase.getDatabaseTypeToken().getType(), fw);
            fw.close();
            BlockDatabase.getLogger().log(Level.INFO, "Database saved successfully");
        }
        catch (Exception e) {
            BlockDatabase.getLogger().log(Level.WARNING, "Couldn't save database");
        }
    }
}

