/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany;

import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import io.github.guillex7.explodeany.configuration.loadable.CannonProjectileConfiguration;
import io.github.guillex7.explodeany.configuration.loadable.VanillaEntityConfiguration;
import io.github.guillex7.explodeany.listener.BlockListener;
import io.github.guillex7.explodeany.listener.CommandListener;
import io.github.guillex7.explodeany.listener.ExplosionListenerManager;
import io.github.guillex7.explodeany.listener.loadable.CannonExplosionListener;
import io.github.guillex7.explodeany.listener.loadable.VanillaExplosionListener;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ExplodeAny
extends JavaPlugin {
    private final String pluginName = "ExplodeAny";
    private final String databaseFilename = "blockDatabase.json";

    public void onEnable() {
        super.onEnable();
        this.getLogger().log(Level.INFO, String.format("%s is LOADING now!", "ExplodeAny"));
        this.loadConfiguration();
        this.loadDatabase();
        this.registerListeners();
    }

    public void onDisable() {
        super.onDisable();
        this.getLogger().log(Level.INFO, String.format("%s is UNLOADING now!", "ExplodeAny"));
        this.unregisterListeners();
        this.saveDatabase();
        this.unloadConfiguration();
    }

    public void loadConfiguration() {
        this.saveDefaultConfig();
        this.reloadConfig();
        ConfigurationManager.getInstance().registerEntityConfiguration(VanillaEntityConfiguration.getInstance());
        ConfigurationManager.getInstance().registerEntityConfiguration(CannonProjectileConfiguration.getInstance());
        ConfigurationManager.getInstance().loadAllEntityConfigurations();
    }

    public void loadDatabase() {
        if (ConfigurationManager.getInstance().doUseBlockDatabase()) {
            BlockDatabase.getInstance().loadFromFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
            BlockDatabase.getInstance().sanitize();
            this.saveDatabase();
        }
    }

    public void registerListeners() {
        ExplosionListenerManager.getInstance().registerExplosionListener(VanillaExplosionListener.getInstance());
        ExplosionListenerManager.getInstance().registerExplosionListener(CannonExplosionListener.getInstance());
        ExplosionListenerManager.getInstance().loadAllExplosionListeners();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        this.getCommand("explodeany").setExecutor((CommandExecutor)new CommandListener());
    }

    public void unloadConfiguration() {
        ConfigurationManager.getInstance().unloadAllEntityConfigurations();
    }

    public void saveDatabase() {
        if (ConfigurationManager.getInstance().doUseBlockDatabase()) {
            BlockDatabase.getInstance().saveToFile(new File(this.getDataFolder(), this.getDatabaseFilename()));
        }
    }

    public void unregisterListeners() {
        ExplosionListenerManager.getInstance().unloadAllExplosionListeners();
    }

    public String getPluginName() {
        return "ExplodeAny";
    }

    public String getDatabaseFilename() {
        return "blockDatabase.json";
    }

    public static ExplodeAny getInstance() {
        return (ExplodeAny)JavaPlugin.getPlugin(ExplodeAny.class);
    }
}

