/*
 * Decompiled with CFR 0.152.
 */
package com.guedosha.simplefeed;

import com.guedosha.simplefeed.ReloadHandler;
import com.guedosha.simplefeed.Simplefeed;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FeedCommand
implements CommandExecutor {
    Plugin plugin = Simplefeed.getPlugin(Simplefeed.class);
    ConsoleCommandSender logger = Bukkit.getConsoleSender();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Configuration config = new ReloadHandler().getConfig();
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (!p.hasPermission("simplefeed.use")) {
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.no-permission").replace("%caster%", p.getName()).replace("%target%", "")));
                return true;
            }
            if (args.length == 0) {
                this.feed(p, false);
            } else if (args.length == 1) {
                String target = args[0];
                Player t = Bukkit.getPlayerExact((String)target);
                if (t == null) {
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-offline").replace("%target%", target).replace("%caster%", p.getName())));
                } else {
                    this.feed(p, t);
                }
            } else {
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.usage").replace("%caster%", p.getName()).replace("%target%", p.getName())));
            }
        } else if (sender instanceof ConsoleCommandSender) {
            if (args.length == 1) {
                String target = args[0];
                Player t = Bukkit.getPlayerExact((String)target);
                if (t == null) {
                    this.logger.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.player-offline").replace("%target%", target).replace("%caster%", "Console")));
                } else {
                    this.feed(t, true);
                }
            } else {
                this.logger.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.usage").replace("%caster%", "").replace("%target%", "Console")));
            }
        }
        return true;
    }

    public void feed(Player caster, Player target) {
        Configuration config = new ReloadHandler().getConfig();
        String targetFed = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.target-fed")).replace("%target%", target.getName()).replace("%caster%", caster.getName());
        String casterFed = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.caster-fed")).replace("%target%", target.getName()).replace("%caster%", caster.getName());
        target.setFoodLevel(20);
        target.sendMessage(targetFed);
        if (!caster.getName().equals(target.getName())) {
            caster.sendMessage(casterFed);
        }
    }

    public void feed(Player target, boolean consoleSender) {
        Configuration config = new ReloadHandler().getConfig();
        if (consoleSender) {
            String targetFed = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.target-fed")).replace("%target%", target.getName()).replace("%caster%", "Console");
            String casterFed = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.caster-fed")).replace("%target%", target.getName()).replace("%caster%", "Console");
            target.setFoodLevel(20);
            target.sendMessage(targetFed);
            this.logger.sendMessage(casterFed);
        } else {
            String targetHealed = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.target-fed")).replace("%target%", target.getName()).replace("%caster%", target.getName());
            target.setFoodLevel(20);
            target.sendMessage(targetHealed);
        }
    }
}

