/*
 * Decompiled with CFR 0.152.
 */
package net.wesjd.anvilgui;

import net.wesjd.anvilgui.version.Version;
import net.wesjd.anvilgui.version.VersionWrapper;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnvilGUI {
    private final Player holder;
    private final ItemStack insert;
    private final ClickHandler clickHandler;
    private final VersionWrapper wrapper;
    private final int containerId;
    private final Inventory inventory;
    private final ListenUp listener = new ListenUp();
    private boolean open = false;

    public AnvilGUI(Plugin plugin, Player holder, String insert, ClickHandler clickHandler) {
        this.holder = holder;
        this.clickHandler = clickHandler;
        ItemStack paper = new ItemStack(Material.PAPER);
        ItemMeta paperMeta = paper.getItemMeta();
        paperMeta.setDisplayName(insert);
        paper.setItemMeta(paperMeta);
        this.insert = paper;
        this.wrapper = Version.getWrapper();
        this.wrapper.handleInventoryCloseEvent(holder);
        this.wrapper.setActiveContainerDefault(holder);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, plugin);
        Object container = this.wrapper.newContainerAnvil(holder);
        this.inventory = this.wrapper.toBukkitInventory(container);
        this.inventory.setItem(0, this.insert);
        this.containerId = this.wrapper.getNextContainerId(holder);
        this.wrapper.sendPacketOpenWindow(holder, this.containerId);
        this.wrapper.setActiveContainer(holder, container);
        this.wrapper.setActiveContainerId(container, this.containerId);
        this.wrapper.addActiveContainerSlotListener(container, holder);
        this.open = true;
    }

    public void closeInventory(boolean fromEvent) {
        Validate.isTrue((boolean)this.open, (String)"You can't close an inventory that isn't open!", (Object[])new Object[0]);
        this.open = false;
        if (!fromEvent) {
            this.wrapper.handleInventoryCloseEvent(this.holder);
        }
        this.wrapper.setActiveContainerDefault(this.holder);
        this.wrapper.sendPacketCloseWindow(this.holder, this.containerId);
        HandlerList.unregisterAll((Listener)this.listener);
    }

    public static class Slot {
        public static final int INPUT_LEFT = 0;
        public static final int INPUT_RIGHT = 1;
        public static final int OUTPUT = 2;
    }

    public static interface ClickHandler {
        public String onClick(Player var1, String var2);
    }

    private class ListenUp
    implements Listener {
        private ListenUp() {
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent e) {
            if (e.getInventory().equals(AnvilGUI.this.inventory)) {
                e.setCancelled(true);
                Player clicker = (Player)e.getWhoClicked();
                if (e.getRawSlot() == 2) {
                    ItemStack clicked = AnvilGUI.this.inventory.getItem(e.getRawSlot());
                    if (clicked == null || clicked.getType() == Material.AIR) {
                        return;
                    }
                    String ret = AnvilGUI.this.clickHandler.onClick(clicker, clicked.hasItemMeta() ? clicked.getItemMeta().getDisplayName() : clicked.getType().toString());
                    if (ret != null) {
                        ItemMeta meta = clicked.getItemMeta();
                        meta.setDisplayName(ret);
                        clicked.setItemMeta(meta);
                        AnvilGUI.this.inventory.setItem(0, clicked);
                    } else {
                        AnvilGUI.this.closeInventory(false);
                    }
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent e) {
            if (e.getInventory().equals(AnvilGUI.this.inventory)) {
                if (AnvilGUI.this.open) {
                    AnvilGUI.this.closeInventory(true);
                }
                e.getInventory().clear();
            }
        }
    }
}

