/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.shop;

import java.util.HashMap;
import java.util.Map;
import net.godlycow.org.shopengine.shop.ShopItem;

public class StockManager {
    private final Map<String, Integer> currentStock = new HashMap<String, Integer>();
    private final Map<String, Integer> configStock = new HashMap<String, Integer>();

    public void initializeStock(ShopItem item) {
        String key = item.getKey();
        int configuredStock = item.getStock();
        if (!this.configStock.containsKey(key)) {
            this.configStock.put(key, configuredStock);
            if (configuredStock >= 0) {
                this.currentStock.putIfAbsent(key, configuredStock);
            } else {
                this.currentStock.put(key, -1);
            }
        }
    }

    public int getCurrentStock(ShopItem item) {
        return this.currentStock.getOrDefault(item.getKey(), item.getStock());
    }

    public void removeStock(ShopItem item, int amount) {
        String key = item.getKey();
        if (this.configStock.getOrDefault(key, -1) >= 0) {
            int stock = this.currentStock.getOrDefault(key, 0);
            this.currentStock.put(key, Math.max(0, stock - amount));
        }
    }

    public void addStock(ShopItem item, int amount) {
        String key = item.getKey();
        if (this.configStock.getOrDefault(key, -1) >= 0) {
            int current = this.currentStock.getOrDefault(key, 0);
            this.currentStock.put(key, current + amount);
        }
    }

    public boolean hasStock(ShopItem item, int requestedAmount) {
        int stock = this.getCurrentStock(item);
        return stock < 0 || stock >= requestedAmount;
    }
}

